package ru.yandex.direct.core.grut.api.utils

import ru.yandex.direct.core.entity.adgroup.model.PageBlock
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration.AdGroupAdditionalTargetingsConfigurationProvider
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AuditoriumGeoSegmentsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ContentCategoriesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DeviceIdsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledApp
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TimeAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.VisitGoalsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.VersionedTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.VersionedTargetingHelper
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.core.entity.retargeting.model.GoalType
import ru.yandex.direct.mysql2grut.enummappers.AdGroupEnumMappers.Companion.toGrutInterfaceLanguage
import ru.yandex.direct.mysql2grut.enummappers.AdGroupEnumMappers.Companion.toGrutJoinType
import ru.yandex.direct.mysql2grut.enummappers.AdGroupEnumMappers.Companion.toGrutTargetingMode
import ru.yandex.direct.mysql2grut.enummappers.AdGroupEnumMappers.Companion.toGrutTargetingType
import ru.yandex.grut.objects.proto.AdGroupAdditionalTargeting.TAdGroupAdditionalTargeting
import ru.yandex.grut.objects.proto.AdGroupAdditionalTargeting.TAdGroupAdditionalTargeting.ETargetingType
import ru.yandex.grut.objects.proto.AdGroupV2
import ru.yandex.grut.objects.proto.RetargetingGoalType.ERetargetingGoalType


class AdGroupAdditionalTargetingConverter {
    companion object {

        fun transformPageBlock(pageBlock: PageBlock): AdGroupV2.TAdGroupV2Spec.TPageBlock {
            return AdGroupV2.TAdGroupV2Spec.TPageBlock.newBuilder().apply {
                blockId = pageBlock.impId
                pageId = pageBlock.pageId
            }.build()
        }

        fun transformTargeting(directEntity: AdGroupAdditionalTargeting, cryptaSegmentsMapping: Map<Long, Goal>): TAdGroupAdditionalTargeting {
            return TAdGroupAdditionalTargeting.newBuilder().apply {
                this.id = directEntity.id
                this.targetingMode = toGrutTargetingMode(directEntity.targetingMode).number
                this.joinType = toGrutJoinType(directEntity.joinType).number
                this.targetingType = typeFromClass(directEntity.javaClass).number
                fillValueField(this, directEntity, cryptaSegmentsMapping)
            }.build()
        }


        val accessors = AdGroupAdditionalTargetingsConfigurationProvider.getAccessors().associate { it.targetingClass to it.targetingType }
        fun typeFromClass(javaClass: Class<AdGroupAdditionalTargeting>): ETargetingType {
            val directEnumValue = accessors[javaClass]
            return toGrutTargetingType(directEnumValue!!)
        }

        fun fillValueField(protoBuilder: TAdGroupAdditionalTargeting.Builder, targeting: AdGroupAdditionalTargeting, cryptaSegmentsMapping: Map<Long, Goal>) {
            when (targeting) {
                is AuditoriumGeoSegmentsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is BrowserEnginesAdGroupAdditionalTargeting ->
                    protoBuilder.versionedEntriesBuilder.addAllValues(targeting.value.map { toVersionedTargetingProto(it) })
                is BrowserNamesAdGroupAdditionalTargeting ->
                    protoBuilder.versionedEntriesBuilder.addAllValues(targeting.value.map { toVersionedTargetingProto(it) })
                is ClidTypesAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is ClidsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is ContentCategoriesAdGroupAdditionalTargeting ->
                    protoBuilder.contentCategoriesBuilder.addAllValues(
                        targeting.value.map { toContentCategoryTargetingProto(it, cryptaSegmentsMapping) })
                is DesktopInstalledAppsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is DeviceIdsAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is DeviceNamesAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is DeviceVendorsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value.map { it.targetingValueEntryId })
                is FeaturesInPPAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is HasLCookieAdGroupAdditionalTargeting -> {
                }
                is HasPassportIdAdGroupAdditionalTargeting -> {
                }
                is InterfaceLangsAdGroupAdditionalTargeting ->
                    protoBuilder.interfaceLanguagesBuilder.addAllValues(targeting.value.map { toGrutInterfaceLanguage(it).number })
                is InternalNetworkAdGroupAdditionalTargeting -> {
                }
                is IsDefaultYandexSearchAdGroupAdditionalTargeting -> {
                }
                is IsMobileAdGroupAdditionalTargeting -> {
                }
                is IsPPLoggedInAdGroupAdditionalTargeting -> {
                }
                is IsTabletAdGroupAdditionalTargeting -> {
                }
                is IsTouchAdGroupAdditionalTargeting -> {
                }
                is IsVirusedAdGroupAdditionalTargeting -> {
                }
                is IsYandexPlusAdGroupAdditionalTargeting -> {
                }
                is MobileInstalledAppsAdGroupAdditionalTargeting ->
                    protoBuilder.installedAppsBuilder.addAllValues(targeting.value.map { toMobileContentProto(it) })
                is OsFamiliesAdGroupAdditionalTargeting ->
                    protoBuilder.versionedEntriesBuilder.addAllValues(targeting.value.map { toVersionedTargetingProto(it) })
                is OsNamesAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value.map { it.targetingValueEntryId })
                is PlusUserSegmentsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is QueryOptionsAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is QueryReferersAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is SearchTextAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is ShowDatesAdGroupAdditionalTargeting ->
                    protoBuilder.datesBuilder.addAllValues(targeting.value.map { moscowLocalDateToGrut(it) })
                is SidsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is TestIdsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is TimeAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value.map { it.originalTimeTarget })
                is UserAgentsAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is UuidsAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is VisitGoalsAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(targeting.value)
                is YandexUidsAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is YandexuidAgeAdGroupAdditionalTargeting ->
                    protoBuilder.intsBuilder.addAllValues(listOf(targeting.value.value.toLong()))
                is YpCookiesAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is YsCookiesAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                is CallerReferrersAdGroupAdditionalTargeting ->
                    protoBuilder.stringsBuilder.addAllValues(targeting.value)
                else ->
                    throw RuntimeException("Unknown additional targeting class: ${targeting::class.java}")
            }
        }

        fun toMobileContentProto(app: MobileInstalledApp): TAdGroupAdditionalTargeting.TMobileApp {
            return TAdGroupAdditionalTargeting.TMobileApp.newBuilder().apply {
                mobileContentId = app.mobileContentId
                if (app.storeUrl != null) {
                    storeUrl = app.storeUrl
                }
            }.build()
        }

        val goalTypeMapping = mapOf(
            GoalType.CONTENT_GENRE to ERetargetingGoalType.RGT_CRYPTA_GENRES_CATEGORY,
            GoalType.CONTENT_CATEGORY to ERetargetingGoalType.RGT_CRYPTA_CONTENT_CATEGORY,
        )

        private fun toContentCategoryTargetingProto(goalId: Long, cryptaSegmentsMapping: Map<Long, Goal>): TAdGroupAdditionalTargeting.TContentCategory {
            return TAdGroupAdditionalTargeting.TContentCategory.newBuilder().apply {
                this.goalId = goalId
                if (!cryptaSegmentsMapping.containsKey(goalId)) {
                    throw java.lang.RuntimeException(
                        "Crypta goals to type mapping doesn't contain goalId: $goalId, dictionary size: ${cryptaSegmentsMapping.size}"
                    )
                }

                val directGoalType = cryptaSegmentsMapping[goalId]!!.type
                this.goalType = goalTypeMapping[directGoalType]!!.number
            }.build()
        }

        private fun toVersionedTargetingProto(versionedTargeting: VersionedTargeting): TAdGroupAdditionalTargeting.TVersionedEntry {
            return TAdGroupAdditionalTargeting.TVersionedEntry.newBuilder().apply {
                id = versionedTargeting.targetingValueEntryId
                if (versionedTargeting.minVersion != null) {
                    minVersion = VersionedTargetingHelper.versionToInt(versionedTargeting.minVersion!!).toLong()
                }
                if (versionedTargeting.maxVersion != null) {
                    maxVersion = VersionedTargetingHelper.versionToInt(versionedTargeting.maxVersion!!).toLong()
                }
            }.build()
        }

    }
}
