package ru.yandex.direct.core.grut.api.utils

import ru.yandex.direct.currency.CurrencyCode

/**
 * Для фишек решили использовать код 999(код для неденежных транзакций https://ru.wikipedia.org/wiki/ISO_4217)
 * 0 плохо, потому что в протобуфе дефолтное значение 0
 * -1 плохо, так как пришлось бы поле делать знаковым
 */
const val YND_FIXED_CURRENCY_CODE = 999
val currencyToIsoCodeMap: Map<CurrencyCode, Int> = CurrencyCode.values()
    .associate { it to calculateIsoCode(it) }

val isoCodeToCurrencyMap: Map<Int, CurrencyCode> = currencyToIsoCodeMap.entries
    .associate { it.value to it.key }


fun toIsoCode(currency: CurrencyCode) = currencyToIsoCodeMap[currency]!!

fun toCurrencyCode(isoCode: Int) = isoCodeToCurrencyMap[isoCode]!!

private fun calculateIsoCode(currency: CurrencyCode): Int {
    if (currency == CurrencyCode.YND_FIXED) {
        return YND_FIXED_CURRENCY_CODE
    }
    val cur = java.util.Currency.getInstance(currency.name)
    return cur.numericCode
}
