package ru.yandex.direct.core.grut.api.utils

import java.time.Duration
import java.util.concurrent.CompletableFuture
import java.util.concurrent.TimeUnit
import ru.yandex.direct.utils.InterruptedRuntimeException

fun <T> waitFutures(futures: Array<CompletableFuture<T>>, timeout: Duration) {
    val commonFuture = CompletableFuture.allOf(*futures)
    try {
        commonFuture.get(timeout.seconds, TimeUnit.SECONDS)
    } catch (e: InterruptedException) {
        Thread.currentThread().interrupt()
        throw InterruptedRuntimeException(e)
    } catch (e: Exception) {
        throw e
    }
}
