package ru.yandex.direct.core.grut.api.utils

import Market.DataCamp.DataCampContractTypes.Currency

val currencyToIsoMap: Map<Currency, Int> = Currency.values()
    .filter { it != Currency.CURRENCY_UNDEFINED }
    .associateWith { calculateIsoCode(it) }

val isoToCurrencyMap: Map<Int, Currency> = currencyToIsoMap.entries
    .associate { it.value to it.key }

data class CurrencyConvertException(override val message: String) : RuntimeException(message)

fun toIsoCode(currency: Currency) = currencyToIsoMap
    .getOrElse(currency) { throw CurrencyConvertException("Unknown currency iso code") }

fun toCurrency(isoCode: Int) = isoToCurrencyMap
    .getOrDefault(isoCode, Currency.CURRENCY_UNDEFINED)

private fun calculateIsoCode(currency: Currency) = java.util.Currency.getInstance(currency.name).numericCode

