package ru.yandex.direct.core.grut.model

import Market.DataCamp.DataCampContractTypes
import java.math.BigDecimal
import java.time.LocalDateTime

data class FeedOfferGrut(
    // id оффера. Может быть null, при создании оффера
    val id: Long?,

    // id клиента, которому принадлежит оффер
    val clientId: Long,

    // Название товара
    val label: String,

    // Описание товара
    val description: String,

    // Ссылка на товар
    val href: String,

    // Список изображений (ссылки в avatars.mds.yandex.net)
    val images: List<String>,

    // Валюта, используемая для цены
    val currencyCode: DataCampContractTypes.Currency,

    // Цена
    val price: FeedOfferPrice,

    // Используется ли товар в фиде
    val isAvailable: Boolean,

    // Время последнего обновления оффера
    val updateTime: LocalDateTime?,

    // Специфичные параметры товара для генерации YML
    val offerParams: FeedOfferParams
)

data class FeedOfferPrice(
    val currentPrice: BigDecimal,
    val oldPrice: BigDecimal?
)

sealed class FeedOfferParams {
    data class Retail(
        val category: String?,
        val vendor: String?,
        val model: String?
    ) : FeedOfferParams()
}
