package ru.yandex.direct.core.grut.replication

import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.grut.GrutContext
import ru.yandex.direct.core.grut.api.AdGroupBriefGrutApi
import ru.yandex.direct.core.grut.api.AdGroupGrutApi
import ru.yandex.direct.core.grut.api.AssetGrutApi
import ru.yandex.direct.core.grut.api.BannerReplicationGrutApi
import ru.yandex.direct.core.grut.api.BidModifierGrutApi
import ru.yandex.direct.core.grut.api.BiddableShowConditionGrutApi
import ru.yandex.direct.core.grut.api.BizLandingGrutApi
import ru.yandex.direct.core.grut.api.BriefAdGroupGrutApi
import ru.yandex.direct.core.grut.api.BriefBannerGrutApi
import ru.yandex.direct.core.grut.api.BriefGrutApi
import ru.yandex.direct.core.grut.api.CampaignGrutApi
import ru.yandex.direct.core.grut.api.ClientGrutApi
import ru.yandex.direct.core.grut.api.ConversionSourceGrutApi
import ru.yandex.direct.core.grut.api.CreativeGrutApi
import ru.yandex.direct.core.grut.api.GrutApiProperties
import ru.yandex.direct.core.grut.api.MinusPhraseGrutApi
import ru.yandex.direct.core.grut.api.MobileContentGrutApi
import ru.yandex.direct.core.grut.api.PricePackageGrutApi
import ru.yandex.direct.core.grut.api.RetargetingConditionGrutApi
import ru.yandex.direct.core.grut.api.StrategyGrutApi
import ru.yandex.direct.core.grut.api.VCardGrutApi

@Lazy
@Service
class GrutApiService(
    grutContext: GrutContext,
    grutApiProperties: GrutApiProperties,
) {
    val campaignGrutDao = CampaignGrutApi(grutContext, grutApiProperties)
    val adGroupGrutDao = AdGroupGrutApi(grutContext, grutApiProperties)
    val clientGrutDao = ClientGrutApi(grutContext, grutApiProperties)
    val minusPhrasesGrutDao = MinusPhraseGrutApi(grutContext, grutApiProperties)
    val mobileContentGrutDao = MobileContentGrutApi(grutContext, grutApiProperties)
    val vcardGrutDao = VCardGrutApi(grutContext, grutApiProperties)
    val creativeGrutDao = CreativeGrutApi(grutContext, grutApiProperties)
    val bannerReplicationApiService = BannerReplicationGrutApi(grutContext, grutApiProperties)
    val briefBannerGrutApi = BriefBannerGrutApi(grutContext, grutApiProperties)
    val briefAdGroupGrutApi = BriefAdGroupGrutApi(grutContext, grutApiProperties)
    val biddableShowConditionReplicationGrutDao = BiddableShowConditionGrutApi(grutContext, grutApiProperties)
    val assetGrutApi = AssetGrutApi(grutContext, grutApiProperties)
    val bidModifierGrutApi = BidModifierGrutApi(grutContext, grutApiProperties)
    val briefGrutApi = BriefGrutApi(grutContext, grutApiProperties)
    val bizLandingGrutApi = BizLandingGrutApi(grutContext, grutApiProperties)
    val retargetingConditionGrutApi = RetargetingConditionGrutApi(grutContext, grutApiProperties)
    val strategyGrutApi = StrategyGrutApi(grutContext, grutApiProperties)
    val adGroupBriefGrutApi = AdGroupBriefGrutApi(grutContext, grutApiProperties)
    val conversionSourceGrutApi = ConversionSourceGrutApi(grutContext, grutApiProperties)
    val pricePackageGrutApi = PricePackageGrutApi(grutContext, grutApiProperties)
}
