package ru.yandex.direct.core.mysql2grut

import com.google.common.base.Supplier
import com.google.common.base.Suppliers
import org.jvnet.hk2.annotations.Service
import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository
import ru.yandex.direct.core.entity.retargeting.model.Goal
import java.util.concurrent.TimeUnit


/**
 * Кэш для справочника сегментов крипты,
 * Использутся при создании ContentCategoriesAdditionalTargetings в Грут: DIRECT-166478
 */
@Repository
class CryptaSegmentsCache(
    private val cryptaSegmentRepository: CryptaSegmentRepository
) {

    private var segmentsMap = getSegmentsMapWithMemoization()
    private var forceRecalculateCache = false;

    private fun getSegmentsMapWithMemoization() = Suppliers.memoizeWithExpiration(
        cryptaSegmentRepository::getContentSegments,
        15, TimeUnit.MINUTES
    )

    @Synchronized
    fun getCryptaSegments(): Map<Long, Goal> {
        if (segmentsMap.get().isEmpty() || forceRecalculateCache) {
            segmentsMap = getSegmentsMapWithMemoization()
            forceRecalculateCache = false;
        }
        return segmentsMap.get()
    }

    @Synchronized
    fun clearCache() {
        forceRecalculateCache = true;
    }
}

