package ru.yandex.direct.core.mysql2grut.repository

import org.jooq.Record
import org.jooq.Record5
import org.jooq.SelectJoinStep
import org.springframework.stereotype.Repository
import ru.yandex.direct.common.util.RepositoryUtils.booleanToLong
import ru.yandex.direct.core.entity.minuskeywordspack.MinusKeywordsPackUtils
import ru.yandex.direct.dbschema.ppc.tables.MinusWords.MINUS_WORDS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

data class MinusPhrase(val id: Long?,
                       val clientId: Long,
                       val name: String?,
                       val phrases: List<String>,
                       val isLibrary: Boolean)

@Repository
open class MinusPhraseRepository(private val dslContextProvider: DslContextProvider) {

    companion object {
        fun mapToMinusPhrase(record: Record): MinusPhrase {
            val items = MinusKeywordsPackUtils.minusKeywordsFromJson(record.get(MINUS_WORDS.MW_TEXT))!!.map { it!! }
            return MinusPhrase(
                record.get(MINUS_WORDS.MW_ID),
                record.get(MINUS_WORDS.CLIENT_ID),
                record.get(MINUS_WORDS.MW_NAME),
                items,
                record.get(MINUS_WORDS.IS_LIBRARY) == 1L,
            )
        }
    }

    private fun selectFields(shard: Int): SelectJoinStep<Record5<Long, Long, String, String, Long>>? {
        return dslContextProvider.ppc(shard)
            .select(
                MINUS_WORDS.MW_ID,
                MINUS_WORDS.CLIENT_ID,
                MINUS_WORDS.MW_NAME,
                MINUS_WORDS.MW_TEXT,
                MINUS_WORDS.IS_LIBRARY,
            ).from(MINUS_WORDS)
    }

    fun getMinusPhrases(shard: Int, minusPhrasesIds: Collection<Long>): List<MinusPhrase> {
        return selectFields(shard)!!
            .where(MINUS_WORDS.MW_ID.`in`(minusPhrasesIds))
            .fetch(Companion::mapToMinusPhrase)
    }

    fun getLibraryMinusPhrases(shard: Int, minusPhrasesIds: Collection<Long>): List<MinusPhrase> {
        return getMinusPhrases(shard, minusPhrasesIds, true);
    }

    fun getMinusPhrases(shard: Int, minusPhrasesIds: Collection<Long>, isLibrary: Boolean): List<MinusPhrase> {
        return selectFields(shard)!!
            .where(MINUS_WORDS.MW_ID.`in`(minusPhrasesIds))
            .and(MINUS_WORDS.IS_LIBRARY.eq(booleanToLong(isLibrary)))
            .fetch(Companion::mapToMinusPhrase)
    }

}
