package ru.yandex.direct.core.mysql2grut.repository

import org.jooq.Record
import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.enums.RetargetingGoalsGoalSource
import ru.yandex.direct.dbschema.ppc.tables.RetargetingGoals.RETARGETING_GOALS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

data class RetargetingGoal(
    val retCondId: Long,
    val goalId: Long,
    val isAccessible: Boolean,
    val goalSource: RetargetingGoalsGoalSource,
)

@Repository
open class RetargetingGoalRepository(private val dslContextProvider: DslContextProvider) {

    fun getRetargetingGoals(shard: Int, retCondsIds: List<Long>): List<RetargetingGoal> {
        return dslContextProvider.ppc(shard).select(
            RETARGETING_GOALS.RET_COND_ID,
            RETARGETING_GOALS.GOAL_ID,
            RETARGETING_GOALS.IS_ACCESSIBLE,
            RETARGETING_GOALS.GOAL_SOURCE,
        ).from(RETARGETING_GOALS)
            .where(RETARGETING_GOALS.RET_COND_ID.`in`(retCondsIds))
            .fetch(Companion::mapToRetargetingCondition)
    }

    companion object {
        fun mapToRetargetingCondition(record: Record): RetargetingGoal {
            return RetargetingGoal(
                retCondId = record.get(RETARGETING_GOALS.RET_COND_ID),
                goalId = record.get(RETARGETING_GOALS.GOAL_ID),
                isAccessible = record.get(RETARGETING_GOALS.IS_ACCESSIBLE) == 1L,
                goalSource = record.get(RETARGETING_GOALS.GOAL_SOURCE),
            )
        }
    }
}
