package ru.yandex.direct.core.security;

import ru.yandex.direct.core.ErrorCodes;
import ru.yandex.direct.core.TranslatableException;
import ru.yandex.direct.i18n.Translatable;

public class AccessDeniedException extends TranslatableException {
    public AccessDeniedException(Translatable detailedMessage) {
        super(ErrorCodes.NO_RIGHTS, SecurityTranslations.INSTANCE.accessDenied(), detailedMessage);
    }

    public AccessDeniedException(String internalMessage, Translatable detailedMessage) {
        super(internalMessage, ErrorCodes.NO_RIGHTS, SecurityTranslations.INSTANCE.accessDenied(), detailedMessage);
    }

    public AccessDeniedException(String internalMessage) {
        super(internalMessage, ErrorCodes.NO_RIGHTS, SecurityTranslations.INSTANCE.accessDenied(), null);
    }

    public AccessDeniedException(String internalMessage, Throwable cause) {
        super(internalMessage, cause, ErrorCodes.NO_RIGHTS, SecurityTranslations.INSTANCE.accessDenied(), null);
    }
}
