package ru.yandex.direct.core.security.authorization;

import java.util.Collection;

import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;

public class AccessDecisionManagerWrapper implements AccessDecisionManager {

    private AccessDecisionManager wrappedManager;

    public AccessDecisionManagerWrapper(AccessDecisionManager sourceManager) {
        this.wrappedManager = sourceManager;
    }

    @Override
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes)
            throws AccessDeniedException, InsufficientAuthenticationException, ru.yandex.direct.core.security.AccessDeniedException {
        try {
            wrappedManager.decide(authentication, object, configAttributes);
        } catch (AccessDeniedException e) {
            throw new ru.yandex.direct.core.security.AccessDeniedException(
                    "access is denied for " + authentication.getName());
        }
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return wrappedManager.supports(attribute);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return wrappedManager.supports(clazz);
    }
}
