package ru.yandex.direct.core.security.authorization;

import org.springframework.util.Assert;

public enum Permission {
    READ,
    WRITE,
    WRITE_SETTINGS;

    public boolean isRead() {
        return this == READ;
    }

    public boolean isWriteSettings() {
        return this == WRITE_SETTINGS;
    }

    public static Permission smartValueOf(Object obj) {
        Assert.notNull(obj, "Object is required");
        return Permission.valueOf(obj.toString().toUpperCase());
    }
}
