package ru.yandex.direct.core.security.authorization;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.springframework.security.access.prepost.PreAuthorize;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Retention(RUNTIME)
@Target(METHOD)
@PreAuthorize("hasPermission(null, 'agency', 'read')")
public @interface PreAuthorizeAgencyRead {
}
