package ru.yandex.direct.core.security.authorization;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.springframework.security.access.prepost.PreAuthorize;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Проверяет, есть ли права на запись у этого оператора для этого клиента (в перле аналог - проверка на право создания
 * кампании)
 */
@Retention(RUNTIME)
@Target(METHOD)
@PreAuthorize("hasPermission(null, 'client', 'write')")
public @interface PreAuthorizeWrite {
}
