package ru.yandex.direct.core.security.tvm;

import javax.annotation.Nonnull;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.inside.passport.tvm2.TvmHeaders;

public class TvmUtils {
    private TvmUtils() {
    }

    /**
     * Возвращает User-тикет, сначала ищет в http-заголовке {@link TvmHeaders#USER_TICKET}
     * если не нашел, то пробует взять из {@link DirectAuthentication#getTvmUserTicket()},
     * иначе вернет пустую строку.
     */
    @Nonnull
    public static String retrieveUserTicket() {
        if (HttpUtil.isRequestExists()) {
            String userTicket = HttpUtil.getRequest().getHeader(TvmHeaders.USER_TICKET);
            if (userTicket != null) {
                return userTicket;
            }
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth instanceof DirectAuthentication
                ? ((DirectAuthentication) auth).getTvmUserTicket().orElse("")
                : "";
    }
}
