package ru.yandex.direct.core.service.grut

import java.util.Locale

class DcTranslator {
    companion object {
        private val SAS_VLA = listOf("sas", "vla")

        @JvmStatic
        fun getClusterByDC(dc: String?) : List<String> {
            val dcLower = dc?.lowercase(Locale.getDefault())
            if (dcLower == null || dcLower == "iva" || dcLower == "myt") {
                return SAS_VLA
            }
            return listOf(dcLower)
        }

        @JvmStatic
        fun getFallbackDC(dc: String?) : List<String>? {
            val dcLower = dc?.lowercase(Locale.getDefault())
            if (dcLower == null || dcLower == "sas") {
                return listOf("vla")
            }
            if (dcLower == "vla") {
                return listOf("sas")
            }
            if (dcLower == "man") {
                return SAS_VLA
            }
            return null
        }
    }
}
