package ru.yandex.direct.core.service.grut

import org.slf4j.LoggerFactory
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.grut.client.ServiceHolder
import ru.yandex.grut.client.ServiceHolder.StubsHolder
import ru.yandex.grut.client.SingleHostServiceHolder
import java.time.Duration

class SwitchableServiceHolder(
    private val balancerServiceHolder: SingleHostServiceHolder,
    private val ypServiceHolder: ServiceHolder,
    ppcPropertiesSupport: PpcPropertiesSupport
) : ServiceHolder {

    private val isGrutBackendsViaYpEnabledProperty = ppcPropertiesSupport.get(
        PpcPropertyNames.IS_GRUT_BACKENDS_VIA_YP_ENABLED,
        Duration.ofMinutes(1)
    )

    private fun getServiceHolder(): ServiceHolder =
        if (isGrutBackendsViaYpEnabledProperty.getOrDefault(false)) {
            LOGGER.trace("Using YP resolver")
            ypServiceHolder
        } else {
            LOGGER.trace("Using balancer resolver")
            balancerServiceHolder
        }

    override fun getStubsHolder(): StubsHolder = getServiceHolder().getStubsHolder()
    override fun tryGetStubsHolder(): StubsHolder? = getServiceHolder().tryGetStubsHolder()

    override fun close() {
        balancerServiceHolder.close()
        ypServiceHolder.close()
    }

    companion object {
        private val LOGGER = LoggerFactory.getLogger(SwitchableServiceHolder::class.java)
    }
}
