package ru.yandex.direct.core.service.integration.balance;

import javax.annotation.Nullable;

import ru.yandex.direct.balance.client.model.response.FindClientResponseItem;
import ru.yandex.direct.currency.CurrencyCode;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Запрос на регистрацию клиента в балансе.
 */
public class RegisterClientRequest {
    private Long clientUid;
    @Nullable
    private Long clientId;
    @Nullable
    private Integer clientTypeId;
    private String name;
    private String email;
    private CurrencyCode currency;
    private boolean agency;
    @Nullable
    private Long countryRegionId;

    @Override
    public String toString() {
        String countryRegionString = ifNotNull(countryRegionId, id -> ", countryRegionId=" + String.valueOf(id));
        countryRegionString = nvl(countryRegionString, "");
        String clientIdString = ifNotNull(clientId, id -> ", clientId=" + String.valueOf(id));
        clientIdString = nvl(clientIdString, "");
        String clientTypeIdString = ifNotNull(clientTypeId, typeId -> ", clientTypeId=" + String.valueOf(typeId));
        clientTypeIdString = nvl(clientTypeIdString, "");
        return "RegisterClientRequest{" +
                "clientUid=" + clientUid +
                clientIdString +
                clientTypeIdString +
                ", name='" + name + '\'' +
                ", email='" + email + '\'' +
                ", currency=" + currency +
                ", agency=" + agency +
                countryRegionString +
                '}';
    }

    public Long getClientUid() {
        return clientUid;
    }

    public RegisterClientRequest withClientUid(Long clientUid) {
        this.clientUid = clientUid;
        return this;
    }

    @Nullable
    public Long getClientId() {
        return clientId;
    }

    public RegisterClientRequest withClientId(@Nullable Long clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    public Integer getClientTypeId() {
        return clientTypeId;
    }

    public RegisterClientRequest withClientTypeId(@Nullable Integer clientTypeId) {
        this.clientTypeId = clientTypeId;
        return this;
    }

    public String getName() {
        return name;
    }

    public RegisterClientRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public RegisterClientRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    public CurrencyCode getCurrency() {
        return currency;
    }

    public RegisterClientRequest withCurrency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    public boolean isAgency() {
        return agency;
    }

    public RegisterClientRequest withAgency(boolean agency) {
        this.agency = agency;
        return this;
    }

    @Nullable
    public Long getCountryRegionId() {
        return countryRegionId;
    }

    public RegisterClientRequest withCountryRegionId(Long countryRegionId) {
        this.countryRegionId = countryRegionId;
        return this;
    }

    public boolean isValid() {
        return clientUid != null
                && name != null
                && name.length() > 0
                && email != null
                && email.length() > 0
                && currency != null
                && (countryRegionId == null || countryRegionId >= 0);
    }

    public void mergeWithFindClientResponseItem(FindClientResponseItem existingClient) {
        this.withClientId(existingClient.getClientId())
                .withClientTypeId(existingClient.getClientTypeId())
                .withName(existingClient.getName())
                .withAgency(!nvl(existingClient.getIsAgency(), 0).equals(0))
                .withEmail(existingClient.getEmail());
    }
}
