package ru.yandex.direct.core.service.integration.balance;

import java.util.Objects;

import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Результат регистрации клиента в балансе
 */
public final class RegisterClientResult {
    private final RegisterClientStatus status;
    private final ClientId clientId;

    private RegisterClientResult(RegisterClientStatus status, ClientId clientId) {
        this.status = status;
        this.clientId = clientId;
    }

    public static RegisterClientResult success(ClientId clientId) {
        return new RegisterClientResult(
                RegisterClientStatus.OK, Objects.requireNonNull(clientId, "clientId"));
    }

    public static RegisterClientResult error(RegisterClientStatus status) {
        Objects.requireNonNull(status, "status");
        if (status.isSuccess()) {
            throw new IllegalArgumentException("status: " + status);
        }
        return new RegisterClientResult(status, null);
    }

    @Override
    public String toString() {
        return "RegisterClientResult{" +
                "status=" + status +
                ", clientId=" + clientId +
                '}';
    }

    public RegisterClientStatus getStatus() {
        return status;
    }

    public ClientId getClientId() {
        return clientId;
    }
}
