package ru.yandex.direct.core.service.integration.balance.model;

import java.math.BigDecimal;
import java.net.URISyntaxException;

import javax.annotation.Nullable;

import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class CreateAndPayRequestResult {
    private static final String TEMPLATE_TAG_MOBILE = "mobile/form";

    private static final Logger logger = LoggerFactory.getLogger(CreateAndPayRequestResult.class);

    private final String paymentUrl;
    private final BigDecimal amount;
    private final ValidationResult<?, Defect> paymentUrlValidationResult;

    public CreateAndPayRequestResult(@Nullable String paymentUrl,
                                     BigDecimal amount,
                                     ValidationResult<?, Defect> paymentUrlValidationResult) {
        this.paymentUrl = paymentUrl;
        this.amount = amount;
        this.paymentUrlValidationResult = paymentUrlValidationResult;
    }

    public String getPaymentUrl(boolean isMobile) {
        try {
            if (paymentUrl != null && isMobile) {
                return new URIBuilder(paymentUrl).addParameter("template_tag", TEMPLATE_TAG_MOBILE)
                        .build()
                        .toASCIIString();
            }
        } catch (URISyntaxException e) {
            logger.error("Can't add template_tag to {}", paymentUrl);
        }

        return paymentUrl;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public ValidationResult<?, Defect>  getPaymentUrlValidationResult() {
        return paymentUrlValidationResult;
    }
}
