package ru.yandex.direct.core.service.integration.balance.model;

import java.util.Map;

import one.util.streamex.StreamEx;

import static java.util.function.Function.identity;

public enum PaymentMethodType {
    UNKNOWN(""),
    CARD("card"),
    OVERDRAFT("overdraft");

    private static final Map<String, PaymentMethodType> paymentMethodByName = StreamEx.of(PaymentMethodType.values())
            .toMap(PaymentMethodType::getBalanceName, identity());
    private final String balanceName;

    PaymentMethodType(String balanceName) {
        this.balanceName = balanceName;
    }

    public static PaymentMethodType fromString(String balanceName) {
        return paymentMethodByName.getOrDefault(balanceName, PaymentMethodType.UNKNOWN);
    }

    public String getBalanceName() {
        return balanceName;
    }

}
