package ru.yandex.direct.core.service.integration.passport;

import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;

import javax.net.ssl.SSLException;

import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;

/**
 * {@link HttpRequestRetryHandler} для неидемпотентных запросов. Отличие от {@link DefaultHttpRequestRetryHandler} в том,
 * что данный хендлер ретраит {@link ConnectException} (полезно в случае морганий сети).
 */
public class NonIdempotentHttpRequestRetryHandler extends DefaultHttpRequestRetryHandler {
    public NonIdempotentHttpRequestRetryHandler() {
        super(3, false, List.of(
                InterruptedIOException.class,
                UnknownHostException.class,
                // ConnectException.class, - закомменчено; это единственное отличие от DefaultHttpRequestRetryHandler
                SSLException.class));
    }
}
