package ru.yandex.direct.core.service.integration.passport;

/**
 * Запрос на регистрацию нового пользователя в паспорте
 */
public final class RegisterUserRequest {
    private String login;
    private String firstName;
    private String lastName;

    @Override
    public String toString() {
        return "RegisterUserRequest{" +
                "login='" + login + '\'' +
                ", firstName='" + firstName + '\'' +
                ", lastName='" + lastName + '\'' +
                '}';
    }

    public String getLogin() {
        return login;
    }

    public RegisterUserRequest withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getFirstName() {
        return firstName;
    }

    public RegisterUserRequest withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getLastName() {
        return lastName;
    }

    public RegisterUserRequest withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }
}
