package ru.yandex.direct.core.service.integration.passport;

import java.util.Objects;

import javax.annotation.Nonnull;

/**
 * Результат регистрации нового пользователя в паспорте
 */
public final class RegisterUserResult {
    private final RegisterUserStatus status;
    private final Long uid;
    private final String email;
    private final String password;

    public RegisterUserResult(
            RegisterUserStatus status,
            Long uid,
            String email,
            String password) {
        this.status = Objects.requireNonNull(status, "status");
        this.uid = uid;
        this.email = email;
        this.password = password;
    }

    @Nonnull
    public static RegisterUserResult success(Long uid, String email, String password) {
        return new RegisterUserResult(
                RegisterUserStatus.OK,
                Objects.requireNonNull(uid, "uid"),
                Objects.requireNonNull(email, "email"),
                Objects.requireNonNull(password, "password"));
    }

    public static RegisterUserResult error(RegisterUserStatus status) {
        Objects.requireNonNull(status, "status");
        if (status.isSuccess()) {
            throw new IllegalArgumentException("status: " + status);
        }
        return new RegisterUserResult(
                status, null, null, null);
    }

    @Override
    public String toString() {
        return "RegisterUserResult{" +
                "status=" + status +
                ", uid=" + uid +
                ", email='" + email + '\'' +
                '}';
    }

    @Nonnull
    public RegisterUserStatus getStatus() {
        return status;
    }

    public Long getUid() {
        return uid;
    }

    public String getEmail() {
        return email;
    }

    public String getPassword() {
        return password;
    }
}
