package ru.yandex.direct.core.service.urlchecker;

import java.util.List;

import static java.util.Objects.requireNonNull;

public class GetRedirectChainResult {

    private final boolean success;
    private final List<String> redirectChain;

    private GetRedirectChainResult(boolean success, List<String> redirectChain) {
        this.success = success;
        this.redirectChain = requireNonNull(redirectChain, "redirect chain is required");
    }

    public static GetRedirectChainResult createSuccessResult(List<String> redirectChain) {
        return new GetRedirectChainResult(true, redirectChain);
    }

    public static GetRedirectChainResult createFailResult(List<String> redirectChain) {
        return new GetRedirectChainResult(false, redirectChain);
    }

    public boolean isSuccessful() {
        return success;
    }

    public List<String> getRedirectChain() {
        return redirectChain;
    }
}
