package ru.yandex.direct.core.service.urlchecker;

public class RedirectCheckResult {

    private final boolean success;
    private final String redirectUrl;
    private final String redirectDomain;

    private RedirectCheckResult(boolean success, String redirectUrl, String redirectDomain) {
        this.success = success;
        this.redirectUrl = redirectUrl;
        this.redirectDomain = redirectDomain;
    }

    public static RedirectCheckResult createSuccessResult(String redirectUrl, String redirectDomain) {
        return new RedirectCheckResult(true, redirectUrl, redirectDomain);
    }

    public static RedirectCheckResult createFailResult() {
        return new RedirectCheckResult(false, null, null);
    }

    public boolean isSuccessful() {
        return success;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public String getRedirectDomain() {
        return redirectDomain;
    }
}
