package ru.yandex.direct.core.smsauth.model;

import java.util.List;

import static java.lang.String.join;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.HashingUtils.getMd5HashUtf8AsHexString;

public class SmsAuthKey {

    private final SmsAuthKeyPrefix keyPrefix = SmsAuthKeyPrefix.USER_VERIFICATION;
    private final List<String> keyParts;

    private SmsAuthKey(List<String> keyParts) {
        this.keyParts = keyParts;
    }

    public static SmsAuthKey ofKeyParts(Object... keyPartsRaw) {
        List<String> keyParts = mapList(List.of(keyPartsRaw), Object::toString);

        return new SmsAuthKey(keyParts);
    }

    public String getPrefix() {
        return keyPrefix.name().toLowerCase();
    }

    public String getSalted() {
        return getMd5HashUtf8AsHexString(join("", keyParts));
    }
}
