package ru.yandex.direct.core.units.api;

/**
 * Интерфейс позволяет получать информацию о балансе баллов пользователя.
 * Подробное описание механизма работы баллов в {@link ru.yandex.direct.core.units.service.UnitsService}
 */
public interface UnitsBalance {

    /**
     * @return ID клиента, являющегося unitsHolder'ом
     */
    Long getClientId();

    /**
     * Количество баллов, которые разрешено израсходовать в текущем интервале до
     * достижения лимита.
     * <br/>
     * Баланс состоит из тех баллов, которые <i>не были</i> потрачены в предыдущие интервалы в рамках скользящего окна.
     * При этом перерасход в ранние интервалы не должен уводить текущий баланс в минус, так как скорее всего был
     * совершён за счёт баллов, накопленных до текущих границ скользящего окна.
     *
     * @return {@code int} &ndash; количество доступных баллов
     */
    int balance();

    /**
     * Количество баллов, израсходованное в рамках скользящего окна (т.е. за текущий
     * и предыдущие intervals() - 1 интервалов)
     *
     * @return {@code int} &ndash; количество израсходованных баллов
     */
    int spent();

    /**
     * Количество баллов, израсходованное в рамках текущего запроса.
     *
     * @return {@code int} &ndash; количество израсходованных баллов
     * @see #withdraw(int)
     */
    int spentInCurrentRequest();

    /**
     * Проверяет - разрешено ли израсходовать указанное количество баллов в рамках скользящего окна
     *
     * @param amount количество баллов
     * @return {@code true}, если указанное количество баллов доступно
     */
    boolean isAvailable(int amount);

    /**
     * Увеличивает счетчик потраченных в текущей операции баллов на указанную величину.
     *
     * @param amount количество баллов
     * @return {@code int} &ndash; количество баллов, которое должно быть реально списано.
     * Это число может отличаться от {@code amount}
     * @see #spentInCurrentRequest()
     */
    int withdraw(int amount);

    /**
     * @return суточный лимит баллов для клиента
     */
    int getLimit();
}
