package ru.yandex.direct.core.units.api;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UnitsBalanceImpl implements UnitsBalance {

    private final int limit;
    private final Long clientId;
    private final int initialSpent;
    private int balance;
    private int spentInCurrentRequest;

    public UnitsBalanceImpl(Long clientId, int limit, int balance, int initialSpent) {
        this.clientId = clientId;
        this.limit = limit;
        this.balance = balance;
        this.initialSpent = initialSpent;
        this.spentInCurrentRequest = 0;
    }

    @Override
    public int balance() {
        return balance;
    }

    @Override
    public int spent() {
        return initialSpent + spentInCurrentRequest;
    }

    @Override
    public int spentInCurrentRequest() {
        return spentInCurrentRequest;
    }

    public int getLimit() {
        return limit;
    }

    @Override
    public boolean isAvailable(int amount) {
        return balance() >= amount;
    }

    @Override
    public int withdraw(int amount) {
        balance = Math.max(0, balance - amount);
        spentInCurrentRequest += amount;
        return amount;
    }

    public Long getClientId() {
        return clientId;
    }

    @Override
    public String toString() {
        return "UnitsBalanceImpl{" +
                "limit=" + limit +
                ", clientId=" + clientId +
                ", initialSpent=" + initialSpent +
                ", balance=" + balance +
                ", spentInCurrentRequest=" + spentInCurrentRequest +
                '}';
    }

}
