package ru.yandex.direct.core.units.decorator;

import ru.yandex.direct.core.units.api.UnitsBalance;

abstract class AbstractUnitsBalanceDecorator implements UnitsBalance {
    protected final UnitsBalance origin;

    AbstractUnitsBalanceDecorator(UnitsBalance origin) {
        this.origin = origin;
    }

    @Override
    public int balance() {
        return this.origin.balance();
    }

    @Override
    public int spent() {
        return this.origin.spent();
    }

    @Override
    public int spentInCurrentRequest() {
        return this.origin.spentInCurrentRequest();
    }

    @Override
    public boolean isAvailable(int amount) {
        return this.origin.isAvailable(amount);
    }

    @Override
    public Long getClientId() {
        return this.origin.getClientId();
    }

    @Override
    public int getLimit() {
        return this.origin.getLimit();
    }

    @Override
    public int withdraw(int amount) {
        return this.origin.withdraw(amount);
    }
}
