package ru.yandex.direct.core.units.decorator;

import com.google.common.primitives.Ints;

import ru.yandex.direct.core.units.api.UnitsBalance;

/**
 * This class allows us to withdraw units wih coefficient
 */
public class AdjustedUnitsBalanceDecorator extends AbstractUnitsBalanceDecorator implements UnitsBalance {
    private final double coefficient;

    public AdjustedUnitsBalanceDecorator(UnitsBalance origin, double coefficient) {
        super(origin);
        this.coefficient = coefficient;
    }

    @Override
    public int withdraw(int amount) {
        return this.origin.withdraw(getAdjustedAmount(amount));
    }

    @Override
    public boolean isAvailable(int amount) {
        return this.origin.isAvailable(getAdjustedAmount(amount));
    }

    private int getAdjustedAmount(int amount) {
        return Ints.saturatedCast(Math.round(amount * coefficient));
    }
}
