package ru.yandex.direct.core.units.decorator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.units.api.UnitsBalance;

public class FreeOfChargeUnitsBalanceDecorator extends AbstractUnitsBalanceDecorator implements UnitsBalance {

    private static final Logger logger = LoggerFactory.getLogger(FreeOfChargeUnitsBalanceDecorator.class);

    public FreeOfChargeUnitsBalanceDecorator(UnitsBalance origin) {
        super(origin);
    }

    @Override
    public boolean isAvailable(int amount) {
        logger.debug("isAvailable return true as given client is free of charge");
        return true;
    }

    @Override
    public int withdraw(int amount) {
        logger.debug("Skip withdrawing of '{}' units as given client is free of charge", amount);
        return 0;
    }
}
