package ru.yandex.direct.core.util

import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder
import ru.yandex.direct.common.net.IpUtils
import ru.yandex.direct.common.util.HttpUtil
import ru.yandex.direct.core.security.DirectAuthentication
import java.net.InetAddress

object CoreHttpUtil {

    /**
     * Возвращает ip пользователя с учётом всех возможных заголовков
     */
    @JvmStatic
    fun getRemoteAddressFromAuthOrDefault(): InetAddress? {
        val auth: Authentication? = SecurityContextHolder.getContext()?.let {it.authentication}
        return if (auth is DirectAuthentication && auth.getUserIp() != null) {
            auth.getUserIp()
        } else {
            try {
                val ip = HttpUtil.getSecretRemoteIp()
                ip?.let { IpUtils.ipFromStringWithOptionalBrackets(it) }
            } catch (e: IllegalStateException) {
                null
            }
        }
    }

}
