package ru.yandex.direct.core.util

import java.time.Duration
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.tracing.TraceProfile
import ru.yandex.direct.tracing.util.TraceUtil
import ru.yandex.grut.client.tracing.TraceCallback
import ru.yandex.grut.client.tracing.TraceCallback.TraceDataHolder
import ru.yandex.grut.client.tracing.TraceInfo

class GrutTraceCallback(private val ppcPropertiesSupport: PpcPropertiesSupport) : TraceCallback {
    // случайный префикс, чтобы по guid можно было понять, что это direct
    val GUID_PREFIX = "d12ec700-00000000-"

    private val grutTraceSamplingProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.GRUT_TRACE_SAMPLING_ENABLED, Duration.ofMinutes(10))

    class TraceDataHolderImpl(
        spanId: String,
        traceId: String,
        shouldSample: Boolean,
        private val traceProfile: TraceProfile
    ) : TraceDataHolder(spanId, traceId, shouldSample) {

        override fun close() {
            traceProfile.close()
        }
    }

    override fun createTraceDataInstance(traceInfo: TraceInfo): TraceDataHolderImpl {
        val currentTrace = Trace.current()
        val spanId = if (currentTrace.spanId != 0L) currentTrace.spanId else TraceUtil.randomId()
        val traceId = if (currentTrace.traceId != 0L) currentTrace.traceId else spanId
        val shouldSample = grutTraceSamplingProperty.getOrDefault(false)

        return TraceDataHolderImpl(
            spanId.toString(),
            formatTraceId(traceId),
            shouldSample,
            currentTrace.profile("grut:${traceInfo.methodName}", traceInfo.objectType?.name?.lowercase()?.removePrefix("ot_") ?: "")
        )
    }

    private fun formatTraceId(traceId: Long) =
        GUID_PREFIX +
            java.lang.Long.toHexString(traceId.ushr(32)) +
            '-' +
            java.lang.Long.toHexString(traceId.and(0xFFFF_FFFFL))
}
