package ru.yandex.direct.core.util;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSimple;
import ru.yandex.direct.core.entity.retargeting.model.ConditionType;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.retargeting.model.RuleType;
import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class HyperGeoUtils {

    private static final int AUDIENCE_OFFSET = 2_000_000_000;

    private HyperGeoUtils() {
    }

    public static Long convertGeoSegmentIdToGoalId(Long geoSegmentId) {
        return geoSegmentId + AUDIENCE_OFFSET;
    }

    public static Long convertGoalIdToGeoSegment(Long goalId) {
        return goalId - AUDIENCE_OFFSET;
    }

    public static RetargetingCondition convertToRetargetingCondition(ClientId clientId, HyperGeoSimple hyperGeo) {
        return (RetargetingCondition) new RetargetingCondition()
                .withClientId(clientId.asLong())
                .withName(hyperGeo.getName())
                .withAvailable(true)
                .withType(ConditionType.geo_segments)
                .withDeleted(false)
                .withLastChangeTime(LocalDateTime.now())
                .withRules(singletonList(
                        new Rule()
                                .withType(RuleType.OR)
                                .withGoals(mapList(hyperGeo.getHyperGeoSegmentIds(),
                                        hyperGeoSegmentId -> (Goal) new Goal().withId(hyperGeoSegmentId)))));
    }
}
