package ru.yandex.direct.core.validation;

import java.util.List;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

/**
 * Класс-контейнер для доступа к базовой валидации идентификаторов при удалении
 */
public class BaseDeleteValidation {

    private BaseDeleteValidation() {
    }

    /**
     * Базовая валидация списка идентификаторов:
     * - проверка на notNull
     * - проверка на положительное значение
     *
     * @param ids список идентификаторов
     * @return результат валидации
     */
    public static ValidationResult<List<Long>, Defect> idsToDeleteValidate(List<Long> ids) {
        return ListValidationBuilder.of(ids, Defect.class)
                .checkEach(notNull())
                .checkEach(validId())
                .getResult();
    }
}
