package ru.yandex.direct.core.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

public interface CommonDefectTranslations extends TranslationBundle {

    CommonDefectTranslations INSTANCE = I18NBundle.implement(CommonDefectTranslations.class);

    @MessageFormatStub("Неверно заданы параметры фильтрации SelectionCriteria")
    Translatable invalidSelectionShort();

    @MessageFormatStub("Параметры запроса указаны неверно")
    Translatable invalidRequestParamsShort();

    @MessageFormatStub("Превышено допустимое количество идентификаторов в массиве {0}")
    Translatable maxIdsInSelectionDetailed(Path path);

    @MessageFormatStub("Массив {0} не может содержать более {1} элементов")
    Translatable maxElementsInSelectionDetailed(Path path, Identity max);

    @MessageFormatStub("В структуре SelectionCriteria не указан обязательный параметр")
    Translatable noNeededParamsInSelectionDetailed();

    @MessageFormatStub("В структуре SelectionCriteria должен быть указан хотя бы один из параметров: {0}")
    Translatable missedParamsInSelectionDetailed(String params);

    @MessageFormatStub("Поле обязательно для заполнения")
    Translatable requiredButEmptyShort();

    @MessageFormatStub("Поле обязательно для заполнения: {0}")
    Translatable requiredButEmptyDetailed(Path path);

    @MessageFormatStub("Не указано значение в поле {0}")
    Translatable absentValueInFieldDetailed(Path path);

    @MessageFormatStub("Не указано время для цели или сегмента Яндекс.Метрики: {0}")
    Translatable requiredTimeForGoalOrSegment(Path path);

    @MessageFormatStub("Превышена допустимая длина")
    Translatable maxStringSizeShort();

    @MessageFormatStub("Допустимая длина поля {0} - {1} символов")
    Translatable maxStringSizeDetailed(Path path, Identity max);

    @MessageFormatStub("Значение в поле {0} не должно превышать {1} символов")
    Translatable lengthOfFieldValueMustNotExceed(Path path, String max);

    @MessageFormatStub("Используются недопустимые символы")
    Translatable invalidCharsShort();

    @MessageFormatStub("Вы можете использовать буквы латинского, турецкого, русского, украинского, белорусского "
            + "и казахского алфавитов, а так же цифры и знаки пунктуации в поле: {0}")
    Translatable invalidCharsDetailed(Path path);

    @MessageFormatStub("В поле {0} допускается использование букв латинского, турецкого, русского, украинского, " +
            "белорусского и казахского алфавитов")
    Translatable mustContainLettersDetailed(Path path);

    @MessageFormatStub("В поле {0} можно использовать только буквы латинского, турецкого, русского, украинского, " +
            "белорусского или казахского алфавита, цифры и знаки пунктуации")
    Translatable mustContainLettersOrDigitsOrPunctuationsDetailed(Path path);

    @MessageFormatStub("Ключевая фраза \"{0}\" не может содержать отдельно стоящие точки")
    Translatable invalidCharsKeywordLoneDotDetailed(String keyword);

    @MessageFormatStub("Неправильное использование точки в ключевой фразе {0}")
    Translatable invalidDot(Path path);

    @MessageFormatStub("В ключевой фразе {0} нельзя одновременно использовать кавычки и минус-слова")
    Translatable bothQuotesAndMinusWords(Path path);

    @MessageFormatStub("Неправильное использование кавычек в ключевой фразе \"{0}\"")
    Translatable invalidCharsUnpairedQuotesDetailed(String keyword);

    @MessageFormatStub("Неправильное использование знака \"-\" в ключевой фразе \"{0}\"")
    Translatable invalidMinusMarkDetailed(String keyword);

    @MessageFormatStub("Указано пустое значение")
    Translatable emptyShort();

    @MessageFormatStub("Поле {0} не должно быть пустым")
    Translatable emptyDetailed(Path path);

    @MessageFormatStub("Поле {0} должно быть пустым")
    Translatable notEmptyDetailed(Path path);

    @MessageFormatStub("Неверный формат")
    Translatable invalidFormatShort();

    @MessageFormatStub("Значение {0} указано в неправильном формате")
    Translatable invalidFormatDetailed(Object value);

    @MessageFormatStub("Значение в поле {0} указано в неправильном формате")
    Translatable invalidFormatWithPathDetailed(Path path);

    @MessageFormatStub("Поле задано неверно")
    Translatable invalidValueShort();

    @MessageFormatStub("В поле {0} указано некорректное значение")
    Translatable invalidValueWithOnlyPathDetailed(Path path);

    @MessageFormatStub("Поле задано неверно: {0} = {1}")
    Translatable invalidValueWithPathDetailed(Path path, Object value);

    @MessageFormatStub("Невалидное значение: {0}")
    Translatable invalidValueDetailed(Object value);

    @MessageFormatStub("Значение поля {0} должно быть целым положительным числом")
    Translatable invalidValueShouldBePositiveDetailed(Path path);

    @MessageFormatStub("Нельзя зарегистрировать клиента Почты для доменов")
    Translatable loginCannotBePdd();

    @MessageFormatStub("Значение поля {0} должно быть в диапазоне от {1} до {2}")
    Translatable fieldMustBeInRange(Path field, Identity min, Identity max);

    @MessageFormatStub("Значение поля {0} должно быть в диапазоне от {1} до {2}")
    Translatable fieldMustBeInRangeTranslatable(Path field, Translatable min, Translatable max);

    @MessageFormatStub("Значение поля {0} должно быть целым положительным числом")
    Translatable fieldShouldBePositive(String field);

    @MessageFormatStub("Значение в поле {0} не может быть меньше {1}")
    Translatable notLessThan(Path path, Translatable min);

    @MessageFormatStub("Значение в поле {0} не может быть больше {1}")
    Translatable notGreaterThan(Path path, Translatable max);

    @MessageFormatStub("Значение в поле {0} должно быть больше {1}")
    Translatable greaterThan(Path path, Translatable max);

    @MessageFormatStub("Неверное использование поля")
    Translatable invalidUseOfFieldShort();

    @MessageFormatStub("Ни одно из полей, указанных в FieldNames, недоступно при получении параметров агентства")
    Translatable invalidRequestAgencyForbiddenFieldsOnlyDetailed();

    @MessageFormatStub("Требуется oauth-токен")
    Translatable invalidRequestOauthTokenRequired();

    @MessageFormatStub("Запрос может выполняться только от обычного клиента")
    Translatable invalidRequestRequiredRegularClient();

    @MessageFormatStub("Неверное использование поля: {0}")
    Translatable invalidUseOfFieldDetailed(Path path);

    @MessageFormatStub("Поле можно задать только для цели или сегмента Яндекс.Метрики: {0}")
    Translatable extraFieldForGoalOrSegment(Path path);

    @MessageFormatStub("Нельзя изменять скоуп ретаргетинга")
    Translatable errorRetargetingScopeChange();


    @MessageFormatStub("Повторяющийся элемент")
    Translatable duplicatedElementShort();

    @MessageFormatStub("Повторяющийся элемент: {0}")
    Translatable duplicatedElementWithPathDetailed(Path path);

    @MessageFormatStub("Повторяющийся элемент")
    Translatable duplicatedElementDetailed(Object value);


    @MessageFormatStub("Неконсистентное состояние объекта")
    Translatable inconsistentStateShort();

    @MessageFormatStub("Неконсистентное состояние объекта")
    Translatable inconsistentStateDetailed();

    @MessageFormatStub("Условие, состоящее только из наборов с типом \"Не выполнено ни одной\", "
            + "может использовать только цели Яндекс.Метрики")
    Translatable invalidGoalsForTypeNoneDetailed();


    @MessageFormatStub("Количество допустимых элементов превышено или равно нулю")
    Translatable invalidCollectionSizeShort();

    @MessageFormatStub("Неверный размер списка {0}; допустимый размер: от {1} до {2}")
    Translatable invalidCollectionSizeDetailed(Path path, Identity min, Identity max);

    @MessageFormatStub("Неверный размер списка {0}; допустимый размер: до {1}")
    Translatable maxCollectionSizeDetailed(Path path, Identity max);

    @MessageFormatStub("Неверный размер списка {0}; допустимый размер: от {1}")
    Translatable minCollectionSizeDetailed(Path path, Identity min);


    @MessageFormatStub("Достигнуто максимальное количество объектов")
    Translatable maxElementsExceededShort();

    @MessageFormatStub("Достигнуто максимальное количество объектов; допустимое количество: {0}")
    Translatable maxElementsExceededDetailed(Identity max);


    @MessageFormatStub("Некорректный запрос")
    Translatable invalidRequestShort();

    @MessageFormatStub("Отсутствует обязательное поле: {0}")
    Translatable absentDetailed(Path path);

    @MessageFormatStub("В структуре SelectionCriteria не задан список идентификаторов")
    Translatable absentIdsInSelection();

    @MessageFormatStub("Пустой список объектов в {0}")
    Translatable emptyElementsList(Path path);

    @MessageFormatStub("Список объектов в {0} должен быть пустой")
    Translatable notEmptyElementsList(Path path);

    @MessageFormatStub("Невозможно удалить объект")
    Translatable unableToDeleteShort();

    @MessageFormatStub("Невозможно получить pin-код")
    Translatable unableToGetPin();

    @MessageFormatStub("Невозможно выполнить действие")
    Translatable сantPerform();

    @MessageFormatStub("Невозможно удалить объект: {0} = {1}")
    Translatable unableToDeleteWithPathDetailed(Path path, Object value);

    @MessageFormatStub("Невозможно удалить объект: {0}")
    Translatable unableToDeleteDetailed(Object value);

    @MessageFormatStub("Запрещено изменять")
    Translatable forbiddenToChangeShort();

    @MessageFormatStub("Объект не найден")
    Translatable notFoundShort();

    @MessageFormatStub("Объект не найден: {0} = {1}")
    Translatable notFoundWithPathDetailed(Path path, Object value);

    @MessageFormatStub("Объект не найден: {0}")
    Translatable notFoundDetailed(Object value);

    @MessageFormatStub("Условие нацеливания на аудиторию не найдено")
    Translatable audienceTargetNotFound();


    @MessageFormatStub("Не поддерживается")
    Translatable notSupportedShort();

    @MessageFormatStub("Ограниченная функциональность")
    Translatable restrictedShort();

    @MessageFormatStub("Превышено ограничение на количество объектов в одном запросе")
    Translatable maxElementsPerRequestShort();

    @MessageFormatStub("Превышено ограничение на количество объектов в одном запросе. Допустимое количество: {0}")
    Translatable maxElementsPerRequestDetailed(Identity max);

    @MessageFormatStub("Слишком широкое условие отбора")
    Translatable tooBroadSelectionClauseShort();

    @MessageFormatStub("Превышено максимальное количество выбираемых корректировок. Значение Limit+Offset не должно " +
            "превышать {0}")
    Translatable tooBroadSelectionClauseDetailed(Identity max);


    @MessageFormatStub("Объект не может присутствовать в запросе более одного раза")
    Translatable duplicatedObjectShort();

    @MessageFormatStub("Объект c таким именем или набором характеристик присутствует в списке более одного раза: {0}")
    Translatable duplicatedObjectWithPathDetailed(Path path);

    @MessageFormatStub("Объект присутствует в списке более одного раза")
    Translatable duplicatedObjectDetailed();

    @MessageFormatStub("Элемент {0} присутствует в списке более одного раза")
    Translatable duplicatedElementDetailedWithoutList(String element);

    @MessageFormatStub("Элемент {0} присутствует в списке {1} более одного раза")
    Translatable duplicatedElementDetailedWithList(String element, String nodeName);

    @MessageFormatStub("Элемент {0} должен присутствовать в списке {1}, но не присутствует")
    Translatable collectionMustContainElementsWithList(String element, String nodeName);

    @MessageFormatStub("Элементы {0} присутствуют в списке более одного раза")
    Translatable duplicatedElementDetailedWithoutListPlural(String elements);

    @MessageFormatStub("Элементы {0} присутствуют в списке {1} более одного раза")
    Translatable duplicatedElementDetailedWithListPlural(String elements, String nodeName);

    @MessageFormatStub("Элементы {0} должны присутствовать в списке {1}, но не присутствуют")
    Translatable collectionMustContainElementsDetailedWithListPlural(String elements, String nodeName);

    @MessageFormatStub("Значение {0} не может повторяться в поле {1} более одного раза")
    Translatable duplicatedValueDetailedWithList(Identity value, String nodeName);

    @MessageFormatStub("Объект c таким именем присутствует в списке более одного раза")
    Translatable duplicatedObjectNameDetailed();

    @MessageFormatStub("Объект c таким набором правил присутствует в списке более одного раза")
    Translatable duplicatedRetConditionRulesDetailed();

    @MessageFormatStub("Id кампании присутствует в запросе более одного раза")
    Translatable duplicatedCampaignId();


    @MessageFormatStub("Объект с указанными характеристиками уже существует")
    Translatable alreadyExistsShort();

    @MessageFormatStub("Объект с указанными характеристиками уже существует: {0}")
    Translatable alreadyExistsDetailed(Path path);


    @MessageFormatStub("Объект присутствует в запросе более одного раза")
    Translatable duplicatedShort();

    @MessageFormatStub("Объект присутствует в запросе более одного раза: {0}")
    Translatable duplicatedDetailed(Path path);

    @MessageFormatStub("Элемент не может присутствовать в списке более одного раза")
    Translatable duplicatedArrayElementShort();

    @MessageFormatStub("Элементы должны присутствовать в списке, но не присутствуют")
    Translatable collectionMustContainElementsShort();

    @MessageFormatStub("Элемент c таким же именем или набором характеристик " +
            "присутствует в списке более одного раза: {0}")
    Translatable duplicatedArrayItemDetailed(Path path);

    @MessageFormatStub("Указанный набор быстрых ссылок дублирует ранее созданный набор")
    Translatable duplicateSitelinkSet();

    @MessageFormatStub("Неверно указаны параметры страницы")
    Translatable incorrectPageShort();

    @MessageFormatStub("Значение параметра Limit должно быть больше 0")
    Translatable incorrectPageNonPositiveLimit();

    @MessageFormatStub("Значение параметра Limit должно быть не больше {0}")
    Translatable incorrectPageLimitExceeded(Identity border);

    @MessageFormatStub("Значение параметра Offset должно быть больше или равно 0")
    Translatable incorrectPageNegativeOffset();

    @MessageFormatStub("Значение параметра Offset должно быть не больше {0}")
    Translatable incorrectPageOffsetExceeded(Identity border);

    @MessageFormatStub("Id условия подбора аудитории не может присутствовать в запросе более одного раза")
    Translatable duplicatedRetargetingConditionId();

    @MessageFormatStub("Условия подбора аудитории должны быть уникальны")
    Translatable duplicatedRetargetingConditionIdForAdGroupId();

    @MessageFormatStub("Не задана продолжительность интересов")
    Translatable interestsTypeIsNotSpecified();

    @MessageFormatStub("Сегменты аудиторий нельзя использовать с данным типом")
    Translatable cryptaGoalsAllowedOnlyForInterestsType();

    @MessageFormatStub("Сегменты аудиторий можно использовать только с условием ИЛИ")
    Translatable cryptaGoalsAllowedOnlyForOrCondition();

    @MessageFormatStub("Цели метрики и крипты в условии не должны пересекаться по ИЛИ")
    Translatable allGoalsAreEitherFromMetrikaOrCrypta();

    @MessageFormatStub("Нельзя сохранять условия по ИЛИ из разных категорий сегментов")
    Translatable allCryptaGoalsMustHaveSameType();

    @MessageFormatStub("Для категории соцдем нельзя пересекать по ИЛИ цели из разных подгрупп")
    Translatable allSocialDemoGoalsMustHaveSameParentId();

    @MessageFormatStub("Нельзя выбрать сразу все варианты")
    Translatable mustNotContainAllElements();

    @MessageFormatStub("В группе не должно быть только условий с отрицанием")
    Translatable allElementsAreNegative();

    @MessageFormatStub("В условии должно быть не более {0} наборов интересов")
    Translatable interestLimitExceeded(Integer limit);

    @MessageFormatStub("Группа объявлений может содержать не более {0} условий подбора аудитории")
    Translatable adGroupLimitExceeded(Identity limit);

    @MessageFormatStub("Группа медийных объявлений может содержать не более одного условия нацеливания на аудиторию")
    Translatable cpmAdGroupLimitExceeded();

    @MessageFormatStub("Группа объявлений может содержать не более одного условия нацеливания на профиль пользователя")
    Translatable adGroupUserProfileLimitExceeded();

    @MessageFormatStub("Недопустимое условие в профиле пользователя, используемого для нацеливания в группе " +
            "текстово-графических объявлений")
    Translatable invalidRetargetingConditionInUserProfileInTgo();

    @MessageFormatStub("Это условие подбора аудитории можно использовать только для корректировки ставок")
    Translatable retargetingConditionIsInvalidForRetargeting();

    @MessageFormatStub("Это условие подбора аудитории нельзя использовать в рамках прайсового пакета")
    Translatable retargetingConditionIsInvalidForPricePackage();

    @MessageFormatStub("Условие подбора аудитории должно сужать аудиторию дефольной группы прайсовой кампании")
    Translatable retargetingConditionIsInvalidForDefaultAdGroup();

    @MessageFormatStub("Нет прав")
    Translatable noRightsShort();

    @MessageFormatStub("Нет прав на объект {0}")
    Translatable noRightsDetailed(Path path);

    @MessageFormatStub("Нет прав на запись")
    Translatable noRightsCantWrite();


    @MessageFormatStub("Указан объект несоответствующего типа")
    Translatable notEligibleObjectShort();

    @MessageFormatStub("Указан объект несоответствующего типа: {0}")
    Translatable notEligibleObjectDetailed(Path path);

    @MessageFormatStub("Запрещено задавать условия нацеливания на аудиторию в указанной группе объявлений")
    Translatable notEligibleAdGroupDetailed();

    @MessageFormatStub("Неверный статус у объекта")
    Translatable badStatusShort();

    @MessageFormatStub("Неверный статус у объекта: {0}")
    Translatable badStatusDetailed(Path path);

    @MessageFormatStub("Запрещено добавлять условия нацеливания на аудиторию в заархивированную кампанию {0}")
    Translatable badCampaignStatusArchived(Identity cid);


    @MessageFormatStub("Такое условие подбора аудитории уже существует в группе")
    Translatable retargetingConditionAlreadyExists();

    @MessageFormatStub("Запрещено добавлять несколько одинаковых таргетингов")
    Translatable duplicatedGoal();

    @MessageFormatStub("Id условия подбора аудитории не может присутствовать в запросе более одного раза")
    Translatable duplicatedRetargetingId();

    @MessageFormatStub("Условие нацеливания на аудиторию не найдено")
    Translatable notFoundRetargetingDetailed();

    @MessageFormatStub("Запрещено останавливать показы по условиям нацеливания на аудиторию в заархивированной " +
            "кампании {0}")
    Translatable badCampaignStatusArchivedOnSuspend(Identity cid);

    @MessageFormatStub("Запрещено запускать показы по условиям нацеливания на аудиторию в заархивированной кампании " +
            "{0}")
    Translatable badCampaignStatusArchivedOnResume(Identity cid);

    @MessageFormatStub("Объект уже остановлен")
    Translatable alreadySuspendedShort();

    @MessageFormatStub("Объект не остановлен")
    Translatable notSuspendedShort();

    @MessageFormatStub("Показы {0} уже остановлены")
    Translatable alreadySuspendedDetailed(Path path);

    @MessageFormatStub("Показы {0} не остановлены")
    Translatable notSuspendedDetailed(Path path);

    @MessageFormatStub("Условие нацеливания на аудиторию уже остановлено")
    Translatable alreadySuspendedRetargetingDetailed();

    @MessageFormatStub("Условие нацеливания на аудиторию не остановлено")
    Translatable notSuspendedRetargetingDetailed();

    @MessageFormatStub("Значение идентификатора должно быть целым положительным числом")
    Translatable incorrectIdDetailed();

    @MessageFormatStub("Запрещено удалять условия нацеливания на аудиторию из заархивированной кампании {0}")
    Translatable cantRemoveAudienceTargetFromArchivedCampaignDetailed(Object cid);

    @MessageFormatStub("Группа объявлений {0} не найдена")
    Translatable adGroupNotFoundDetailed(Identity adGroupId);

    @MessageFormatStub("Кампания не найдена")
    Translatable campaignNotFound();

    @MessageFormatStub("Кампания {0} не найдена")
    Translatable campaignNotFoundDetailed(Identity campaignId);

    @MessageFormatStub("Тип кампании не поддерживается")
    Translatable campaignTypeNotSupportedDetailed();

    @MessageFormatStub("Невозможно заархивировать объект")
    Translatable cannotArchiveObject();

    @MessageFormatStub("Невозможно заархивировать кампанию с деньгами")
    Translatable campaignWithMoneyArchivingDetailed();

    @MessageFormatStub("Для архивации кампания должна быть остановлена и с момента остановки и последнего показа" +
            " должно пройти не менее 60 минут")
    Translatable nonStoppedCampaignArchivingDetailed();

    @MessageFormatStub("Объект уже заархивирован")
    Translatable objectAlreadyArchived();

    @MessageFormatStub("Кампания уже заархивирована")
    Translatable campaignAlreadyArchivedDetailed();

    @MessageFormatStub("Объект не заархивирован")
    Translatable objectNotArchived();

    @MessageFormatStub("Кампания не заархивирована")
    Translatable campaignNotArchivedDetailed();

    @MessageFormatStub("Невозможно разархивировать объект")
    Translatable cannotExtractObjectFromArchive();

    @MessageFormatStub("Кампания {0} не может быть разархивирована, так как находится в специальном архиве.")
    Translatable campaignIsInSpecialArchivedState(String camp);

    @MessageFormatStub("Превышено максимальное количество незаархивированных кампаний — {0}")
    Translatable unarcCampaignsLimitExceededDetailed(Identity limit);

    @MessageFormatStub("Кампания уже остановлена")
    Translatable campaignAlreadySuspendedDetailed();

    @MessageFormatStub("Кампания не остановлена")
    Translatable campaignNotSuspendedDetailed();

    @MessageFormatStub("Медийные кампании отключены")
    Translatable cpmBannerCampaignDisabled();

    @TranslationStub("Минус-фразы недоступны для кампании данного типа")
    Translatable minusKeywordsAreNotAllowedForCampaign();

    @TranslationStub("Неверное количество доменов для запрещения")
    Translatable wrongDisabledDomainsLimit();

    @MessageFormatStub("Стратегия на поиске может содержать не больше одной структуры с настройками")
    Translatable searchStrategyHasMoreThanOneStructureWithSettings();

    @MessageFormatStub("Стратегия в Рекламной сети может содержать не больше одной структуры с настройками")
    Translatable networkStrategyHasMoreThanOneStructureWithSettings();

    @MessageFormatStub("Структура с параметрами для стратегии на поиске не соответствует названию стратегии")
    Translatable structureForSearchStrategyDoesNotMatchStrategyName();

    @MessageFormatStub("Структура с параметрами для стратегии в Рекламной сети не соответствует названию стратегии")
    Translatable structureForNetworkStrategyDoesNotMatchStrategyName();

    @MessageFormatStub("Стратегия {0} на поиске должна содержать структуру с настройками")
    Translatable searchStrategyMustContainStructureWithSettings(String strategyType);

    @MessageFormatStub("Стратегия {0} в Рекламной сети должна содержать структуру с настройками")
    Translatable networkStrategyMustContainStructureWithSettings(String strategyType);

    @MessageFormatStub("Стратегия IMPRESSIONS_BELOW_SEARCH не поддерживается")
    Translatable impressionsBelowSearchStrategyIsNotSupported();

    @MessageFormatStub("Стратегии не совместимы")
    Translatable strategiesAreNotCompatible();

    @MessageFormatStub("Группа объявлений данного типа не поддерживается")
    Translatable adGroupTypeNotSupportedDetailed();

    @MessageFormatStub("Запрещено изменять заархивированную кампанию")
    Translatable cantEditArchivedCampaignDetailed();

    @MessageFormatStub("Условие подбора аудитории не найдено")
    Translatable retargetingConditionNotFoundDetailed();

    @MessageFormatStub("Условие подбора аудитории {0} не найдено")
    Translatable retargetingConditionNotFoundDetailedWithId(Identity retCondId);

    @MessageFormatStub("Не передано ни одного из необходимых полей")
    Translatable requiredAtLeastOneOfFieldsShort();

    //todo maxlog: тут надо подумать над тем, как имена полей преобразовывать при отдаче сообщения в API
    @MessageFormatStub("Одно из полей {0} должно быть указано")
    Translatable requiredAtLeastOneOfFieldsDetailed(String fields);

    @MessageFormatStub("Одно из полей {0}, {1} должно быть указано")
    Translatable requiredAtLeastOneOfFieldsTwoElements(Path first, Path second);

    @MessageFormatStub("Разрешено создавать не более {0} условий нацеливания на аудиторию в одном запросе")
    Translatable retargetingsAddLimitExceeded(Identity limit);

    @MessageFormatStub("Разрешена установка ставок не более чем для {0} условий нацеливания на аудиторию в одном " +
            "запросе")
    Translatable maxElementsPerRequestRetargetingIdsDetailed(Identity limit);

    @MessageFormatStub("Разрешена установка ставок на условия нацеливания на аудиторию не более чем для {0} групп " +
            "объявлений в одном запросе")
    Translatable maxElementsPerRequestRetargetingAdGroupIdsDetailed(Identity limit);

    @MessageFormatStub("Разрешена установка ставок на условия нацеливания на аудиторию не более чем для {0} кампаний " +
            "в одном запросе")
    Translatable maxElementsPerRequestRetargetingCampaignIdsDetailed(Identity limit);

    @MessageFormatStub("Передано больше чем одно поле")
    Translatable possibleOnlyOneFieldShort();

    @MessageFormatStub("Только одно из полей {0} должно быть указано")
    Translatable possibleOnlyOneFieldDetailed(String fields);

    @MessageFormatStub("В одном запросе необходимо использовать Id одного типа")
    Translatable mixedTypesShort();

    @MessageFormatStub("В одном запросе заданы несовместимые операции")
    Translatable mixedOperationsShort();

    @MessageFormatStub("Не удалось найти условия нацеливания на аудиторию для {0}")
    Translatable notFoundRetargetingByTypeDetailed(Identity retargetingId);

    @MessageFormatStub("Не удалось найти условия нацеливания на аудиторию для указанных параметров")
    Translatable notFoundAudienceTargetByParametersDetailed();

    @MessageFormatStub("Элемент массива не может иметь значение null")
    Translatable absentRequiredElement();

    @MessageFormatStub("Запрещено изменять ставки для условий нацеливания на аудиторию в заархивированной кампании {0}")
    Translatable badCampaignStatusArchivedOnUpdateBids(Identity campaignId);

    @MessageFormatStub("Запрещено изменять заархивированную кампанию")
    Translatable badCampaignStatusArchivedCanNotChange();

    @MessageFormatStub("Не передано ни одного из необходимых параметров")
    Translatable noOneOfRequiredParametersShort();

    @MessageFormatStub("Один из параметров {0} должен быть указан")
    Translatable noOneOfRequiredParametersDetailed(String params);

    @MessageFormatStub("Указаны взаимоисключающие параметры")
    Translatable mutuallyExclusiveParametersShort();

    @MessageFormatStub("Указаны взаимоисключающие параметры, только один из которых может присутствовать в запросе")
    Translatable mutuallyExclusiveParametersDetailed();

    @MessageFormatStub("Только один параметр из {0} может быть указан")
    Translatable mutuallyExclusiveParametersWithElements(String params);

    @MessageFormatStub("Только один из параметров {0} и {1} может быть задан")
    Translatable mutuallyExclusiveParametersTwoElements(Path first, Path second);

    @MessageFormatStub("Параметр {0} несовместим со значением {2} в параметре {1}")
    Translatable mutuallyExclusiveParameterOneAndParameterTwoValue(Path first, Path second, String secondValue);

    @MessageFormatStub("В условии нацеливания на аудиторию допускаются только интересы, для которых установлено " +
            "значение YES признака IsTargetable")
    Translatable inconsistentStateTargetingCategoryUnavailable();

    @MessageFormatStub("Указанный набор быстрых ссылок используется и не может быть удалён")
    Translatable inconsistentStateSitelinkSetCannotBeDeleted();

    @MessageFormatStub("Получение Settings недоступно для клиента нескольких агентств")
    Translatable notAllowedGetSettingsClientMultipleAgencies();

    @MessageFormatStub("Получение полей VatRate, OverdraftSumAvailable недоступно для клиента нескольких агентств")
    Translatable notAllowedGetNdsClientMultipleAgencies();

    @TranslationStub("Ошибка операции")
    Translatable operationError();

    @TranslationStub("Не удалось получить данные торгов. Повторите запрос позже")
    Translatable bsAuctionUnavailable();

    @TranslationStub("Не удалось назначить ставки. Повторите запрос позже")
    Translatable bidsSetFailed();

    @MessageFormatStub("Некорректное использование стоп-слов")
    Translatable stopWordsShort();

    @MessageFormatStub("Ключевая фраза {0} не может состоять только из стоп-слов: союзов, предлогов, частиц")
    Translatable stopWordsDetailed(Path path);

    @MessageFormatStub("Некорректное использование минус-слов")
    Translatable minusWordsShort();

    @MessageFormatStub("Превышена допустимая длина минус-слова")
    Translatable minusWordMaxLengthShort();

    @MessageFormatStub("Ключевая фраза {0} не может состоять только из минус-слов")
    Translatable minusWordsOnlyDetailed(Path path);

    @MessageFormatStub("Превышена допустимая длина отдельного минус-слова в {0} символов")
    Translatable minusWordMaxLengthOnlyDetailed(int maxLength);

    @MessageFormatStub("Превышена допустимая длина слова в ключевой фразе")
    Translatable keywordMaxLengthShort();

    @MessageFormatStub("Длина слова в ключевой фразе не должна превышать {0} символов")
    Translatable keywordMaxLengthDetailed(int maxLength);

    @MessageFormatStub("В ключевой фразе {0} превышена допустимая длина отдельного ключевого слова в {1} символов. " +
            "Ошибки в словах: {2}.")
    Translatable keywordMaxLengthDetailedWords(Path path, int maxLength, String keyword);

    @MessageFormatStub("Ключевое слово уже существует")
    Translatable keywordAlreadyExistsShort();

    @MessageFormatStub("Ключевая фраза содержит много слов")
    Translatable maxWordsShort();

    @MessageFormatStub("Ключевая фраза {0} не может состоять более чем из {1} слов")
    Translatable maxWordsDetailed(Path path, int maxWords);

    @MessageFormatStub("Геотаргетинг задан неправильно")
    Translatable badGeoShort();

    @MessageFormatStub("Язык не соответствует геотаргетингу")
    Translatable inconsistentLanguageAndGeoShort();

    @MessageFormatStub("Указание региона 0 исключает возможность указания других плюс-регионов")
    Translatable badGeoDetailedIncorrectUseOfZeroRegion();

    @MessageFormatStub("Список регионов пуст")
    Translatable badGeoDetailedEmptyRegions();

    @MessageFormatStub("Неверные или несуществующие регионы: {0}")
    Translatable badGeoDetailedIncorrectRegions(String regionIds);

    @MessageFormatStub("Регионы {1} полностью исключают регионы {1}")
    Translatable badGeoDetailedMinusRegionMatchesPlusRegion(String minusRegionIds, String plusRegionIds);

    @MessageFormatStub("Регионы указаны более одного раза: {0}")
    Translatable badGeoDetailedNonUniqueRegions(Translatable regions);

    @MessageFormatStub("В данных регионах не будет показов на десктопной версии сайта, так как цена за показ не " +
            "соответствует требуемому диапазону: {0}")
    Translatable regionsIgnoredDesktopBecauseOfPrice(Translatable regions);

    @MessageFormatStub("В данных регионах не будет показов на мобильной версии сайта, так как цена за показ не " +
            "соответствует требуемому диапазону: {0}")
    Translatable regionsIgnoredMobileBecauseOfPrice(Translatable regions);

    @MessageFormatStub("В данных регионах не будет показов на новой вкладке браузера, так как цена за показ не " +
            "соответствует требуемому диапазону: {0}")
    Translatable regionsIgnoredBrowserNewTabBecauseOfPrice(Translatable regions);

    @MessageFormatStub("Невозможно исключить регионы, не входящие ни в один из регионов показа")
    Translatable badGeoDetailedNoPlusRegions();

    @MessageFormatStub("Невозможно исключить регионы, не входящие ни в один из регионов показа. Исключаемые регионы: " +
            "{0}")
    Translatable badGeoDetailedMinusRegionsWithoutPlusRegions(Translatable minusRegions);

    @MessageFormatStub("Неправильное использование скобок [] в ключевой фразе \"{0}\"")
    Translatable invalidCharsUnpairedSquareBracketsDetailed(String keyword);

    @MessageFormatStub("В ключевой фразе \"{0}\" квадратные скобки [] не могут быть пустыми и вложенными")
    Translatable invalidCharsEmptyOrNestedSquareBrackets(String keyword);

    @MessageFormatStub("В ключевой фразе \"{0}\" внутри скобок [] не допустимы модификаторы \"+\" и \"-\"")
    Translatable invalidCharsModifiersInsideSquareBrackets(String keyword);

    @MessageFormatStub("В ключевой фразе \"{0}\" неправильное использование знака \"!\"")
    Translatable invalidCharsIncorrectUseOfExclamationMarks(String keyword);

    @MessageFormatStub("В ключевой фразе \"{0}\" неправильное использование знака \"-\"")
    Translatable invalidCharsIncorrectUseOfMinusSign(String keyword);

    @MessageFormatStub("В ключевой фразе \"{0}\" неправильное использование знака \"+\"")
    Translatable invalidCharsIncorrectUseOfPlusSign(String keyword);

    @MessageFormatStub("Из ключевой фразы {0} могут вычитаться только отдельные слова, а не словосочетания")
    Translatable minusWordsNoMinusPhrasesDetailed(Path path);

    @MessageFormatStub("Из ключевой фразы {0} нельзя вычитать словосочетания, содержащие точку")
    Translatable minusWordsPhraseWithDot(Path path);

    @MessageFormatStub("В ключевой фразе {0} неправильное сочетание специальных символов")
    Translatable minusWordsIncorrectCombinationOfSpecialSymbols(Path path);

    @MessageFormatStub("В ключевой фразе {0} слова не могут начинаться с точек и апострофов")
    Translatable minusWordsCantStartWithDotOrApostroph(Path path);

    @MessageFormatStub("В ключевой фразе {0} словосочетание в кавычках не может состоять из минус-слов")
    Translatable minusWordsNotInQuotedPhrase(Path path);

    @MessageFormatStub("В ключевой фразе {0} минус-слово может содержать не более двух цифр подряд через точку")
    Translatable minusWordsSingleDotOnly(Path path);

    @MessageFormatStub("В ключевой фразе {0} нельзя вычитать слова, содержащиеся в исходной ключевой фразе. Например," +
            " нельзя вычитать слово \"кино\", содержащиеся в исходной ключевой фразе \"билет в кино\"")
    Translatable minusWordsCantSubtractPlusWords(Path path);

    @MessageFormatStub("Объект уже помечен как удаленный")
    Translatable objectAlreadyMarkedAsDeletedShort();

    @MessageFormatStub("Расширение уже помечено как удаленное")
    Translatable objectAlreadyMarkedAsDeletedDetailed();

    @MessageFormatStub("Магазин приложений не поддерживается")
    Translatable unsupportedAppStore();

    @MessageFormatStub("Объекты уже связаны")
    Translatable objectsAlreadyBound();

    @MessageFormatStub("Объекты не связаны")
    Translatable objectsAreNotBound();

    @MessageFormatStub("Необходимо указать ссылку на сайт или турбо-страницу")
    Translatable oneOfHrefOrTurboLandingIdMustBeNotNull();

    @MessageFormatStub("Необходимо указать ссылку на сайт, турбо-страницу или визитку")
    Translatable oneOfHrefOrTurboLandingIdOrVcardIdMustBeNotNull();

    @MessageFormatStub("Переданная временная метка пакета не совпадает с ожидаемой. Ожидается {0}")
    Translatable pricePackageTimestampNotEqualsUserTimestamp(String expectedTimestamp);

    @MessageFormatStub("Недостаточно карточек для размещения коллекции. Минимальное количество – {0}.")
    Translatable notEnoughCardsInNewCollection(int minWords);

    @MessageFormatStub("Возможно, в текущей коллекции недостаточно карточек. Минимальное количество - {0}.")
    Translatable notEnoughCardsinExistingCollection(int minwords);

    @MessageFormatStub("Контент недоступен")
    Translatable contentInaccessibleGetmeta();

    @MessageFormatStub("Контент не найден")
    Translatable contentNotFoundGetmeta();

    @MessageFormatStub("Неподдерживаемый тип контента")
    Translatable contentTypeIsNotSupported();

    @MessageFormatStub("Разрешено добавлять не более {0} единиц продвигаемого контента в одном запросе")
    Translatable maxContentPromotionPerAddRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено добавлять не более {0} единиц продвигаемого контента с типом {1} в одном запросе")
    Translatable maxContentPromotionWithTypePerAddRequestDetailed(Identity max, String contentType);

    @MessageFormatStub("Передан неправильный тип контента в запросе")
    Translatable wrongContentPromotionContentType();

    @MessageFormatStub("Элемент массива {0} не может быть пустой строкой")
    Translatable arrayElementContainsBlankString(String arrayName);

    @MessageFormatStub("Часовой пояс не существует")
    Translatable timeZoneDoesntExist();

    @MessageFormatStub("Настройка не будет изменена")
    Translatable settingWillNotBeChanged();

    @MessageFormatStub("Настройка {0} больше не поддерживается")
    Translatable settingIsDeprecated(String setting);

    @MessageFormatStub("Параметр не будет применен")
    Translatable parameterWillNotBeApplied();

    @MessageFormatStub("Запрещено выключать все категории в автотаргетинге")
    Translatable disableAllAutotargetingCategoriesIsForbidden();

    @MessageFormatStub("Элемент {1} списка {0} - нельзя запрещать IP-адреса из частных подсетей")
    Translatable ipCantBeFromPrivateNetwork(String list, Object value);

    @MessageFormatStub("Значение в поле {0} должно совпадать с одним из значений {1}")
    Translatable fieldMustBeInList(String field, String list);

    @MessageFormatStub("Указанная цель не найдена.")
    Translatable goalNotFound();

    @MessageFormatStub("Изменение не будет иметь эффекта")
    Translatable noEffect();

    @MessageFormatStub("Дневной бюджет сброшен")
    Translatable dailyBudgetReset();

    @MessageFormatStub("Дневной бюджет не указан")
    Translatable weeklyBudgetNotSpecified();

    @MessageFormatStub("Значение даты в поле {0} не может быть меньше текущей даты")
    Translatable dateCantBeEarlierThanNow(Path path);

    @MessageFormatStub("Указанные параметры URL неккоректны")
    Translatable hrefParamsInvalid();

    @MessageFormatStub("Превышена допустимая длина параметров URL")
    Translatable hrefParamsMaxLength();

}
