package ru.yandex.direct.core.validation.defects;

import java.util.List;

import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectIds;
import ru.yandex.direct.core.validation.defects.ids.AdDefectIds;
import ru.yandex.direct.core.validation.defects.params.CollectionValuesDefectParams;
import ru.yandex.direct.validation.defect.ids.StringDefectIds;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectIds;

public class Defects {

    private Defects() {
    }

    public static Defect<Void> pddLogin() {
        return new Defect<>(DefectIds.LOGIN_CANNOT_BE_PDD);
    }

    public static Defect<Void> metrikaReturnsResultWithErrors() {
        return new Defect<>(DefectIds.METRIKA_RETURNS_RESULT_WITH_ERRORS);
    }

    public static Defect<Void> badStatusCampaignArchived() {
        return new Defect<>(DefectIds.CAMPAIGN_STATUS_ARCHIVED);
    }

    public static Defect<Void> hrefOrTurboRequired() {
        return new Defect<>(DefectIds.ONE_OF_HREF_OR_TURBOLANDING_ID_MUST_BE_NOT_NULL);
    }

    public static Defect<StringDefectParams> maxCountWordsInKeyword(int maxStringLength) {
        return new Defect<>(StringDefectIds.MAX_COUNT_WORDS_IN_KEYWORD,
                new StringDefectParams().withMaxWords(maxStringLength));
    }

    public static Defect<NumberDefectParams> negativeKeywordSetsLimitExceeded(Number max) {
        return new Defect<>(MinusPhraseDefectIds.Number.NEGATIVE_KEYWORD_SETS_LIMIT_EXCEEDED,
                new NumberDefectParams().withMax(max));
    }

    public static Defect<Void> phoneMustBeVerified() {
        return new Defect<>(DefectIds.PHONE_MUST_BE_VERIFIED);
    }

    public static Defect<Void> promocodeDomainOrClientDoesNotMatch() {
        return new Defect<>(DefectIds.PROMOCODE_DOMAIN_OR_CLIENT_DOES_NOT_MATCH);
    }

    public static Defect<Void> promocodeClientHasMultipleDomains() {
        return new Defect<>(DefectIds.PROMOCODE_CLIENT_HAS_MULTIPLE_DOMAINS);
    }

    public static Defect<Void> promocodeClientDoesNotMatch() {
        return new Defect<>(DefectIds.PROMOCODE_CLIENT_DOES_NOT_MATCH);
    }

    public static Defect<Void> promocodeDomainDoesNotMatch() {
        return new Defect<>(DefectIds.PROMOCODE_CLIENT_DOMAIN_DOES_NOT_MATCH);
    }

    public static Defect<CollectionValuesDefectParams<Long>> requiredImpressionRateDueToAdsHasCloseCounter(
            List<Long> adWithCloseCounterVarIds) {
        return new Defect<>(AdDefectIds.AdIds.REQUIRED_IMPRESSION_RATE_DUE_TO_ADS_HAS_CLOSE_COUNTER,
                CollectionValuesDefectParams.of(adWithCloseCounterVarIds));
    }

}
