package ru.yandex.direct.core.validation.defects;

import java.util.Collection;
import java.util.stream.Collectors;

import ru.yandex.direct.core.entity.bids.validation.BidsDefects;
import ru.yandex.direct.core.validation.defects.ids.CurrencyDefectIds;
import ru.yandex.direct.core.validation.defects.params.CurrencyAmountDefectParams;
import ru.yandex.direct.core.validation.defects.params.UnavailableCurrencyDefectParams;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.validation.result.Defect;

public class MoneyDefects {
    //currency amount
    public static Defect<CurrencyAmountDefectParams> invalidValueNotLessThan(Money min) {
        return new Defect<>(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN,
                new CurrencyAmountDefectParams(min));
    }

    public static Defect<CurrencyAmountDefectParams> invalidValueNotGreaterThan(Money max) {
        return new Defect<>(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX,
                new CurrencyAmountDefectParams(max));
    }

    public static Defect<CurrencyAmountDefectParams> invalidValueCpmNotLessThan(Money min) {
        return new Defect<>(BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_GREATER_THAN_MIN,
                new CurrencyAmountDefectParams(min));
    }

    public static Defect<CurrencyAmountDefectParams> invalidValueCpmNotGreaterThan(Money max) {
        return new Defect<>(BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_SMALLER_THAN_MAX,
                new CurrencyAmountDefectParams(max));
    }

    // AvailableCurrencyDefectParams
    public static Defect<UnavailableCurrencyDefectParams> unavailableCurrency(
            CurrencyCode currency, Collection<CurrencyCode> availableCurrencies) {
        return new Defect<>(CurrencyDefectIds.Availability.UNAVAILABLE_CURRENCY,
                new UnavailableCurrencyDefectParams(
                        currency, availableCurrencies.stream().sorted().collect(Collectors.toList())));
    }
}
