package ru.yandex.direct.core.validation.defects.ids;

import ru.yandex.direct.core.validation.defects.params.CurrencyAmountDefectParams;
import ru.yandex.direct.core.validation.defects.params.UnavailableCurrencyDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class CurrencyDefectIds {
    private CurrencyDefectIds() {
    }

    public enum Amount implements DefectId<CurrencyAmountDefectParams> {
        MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
        MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
    }

    public enum Availability implements DefectId<UnavailableCurrencyDefectParams> {
        UNAVAILABLE_CURRENCY
    }
}
