package ru.yandex.direct.core.validation.defects.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Параметры для DefectId, когда при ошибке дополнительно нужно передать список значений
 * Например id баннеров из-за которых нельзя изменить какой-нибудь параметр группы/кампании
 */
@ParametersAreNonnullByDefault
public class CollectionValuesDefectParams<T> {

    private final List<T> values;

    private CollectionValuesDefectParams(Collection<T> values) {
        this.values = new ArrayList<>(values);
    }

    public static <T> CollectionValuesDefectParams<T> of(@Nullable Collection<T> values) {
        return new CollectionValuesDefectParams<>(checkNotNull(values));
    }

    public List<T> getValues() {
        return values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CollectionValuesDefectParams<?> that = (CollectionValuesDefectParams<?>) o;

        return values.equals(that.values);
    }

    @Override
    public int hashCode() {
        return values.hashCode();
    }

    @Override
    public String toString() {
        return "CollectionValuesDefectParams{" +
                "values=" + values +
                '}';
    }

}
