package ru.yandex.direct.core.validation.defects.params;

import java.util.Arrays;
import java.util.Collection;

import ru.yandex.direct.queryrec.model.Language;

public class ContentLanguageDefectParams {
    private Language language;
    private Collection<Long> adGroupIds;

    public Language getLanguage() {
        return language;
    }

    public Collection<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public ContentLanguageDefectParams withLanguage(final Language language) {
        this.language = language;
        return this;
    }

    public ContentLanguageDefectParams withAdGroupIds(Collection<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    @Override
    public String toString() {
        return "GeoDefectParams{" +
                "language=" + language +
                ", adGroupIds=" + Arrays.toString(adGroupIds.toArray()) +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ContentLanguageDefectParams that =
                (ContentLanguageDefectParams) o;

        if (language != that.language) {
            return false;
        }
        return adGroupIds != that.adGroupIds ? adGroupIds.equals(that.adGroupIds) : that.adGroupIds == null;
    }

    @Override
    public int hashCode() {
        int result = language != null ? language.hashCode() : 0;
        result = 31 * result + (adGroupIds != null ? adGroupIds.hashCode() : 0);
        return result;
    }
}
