package ru.yandex.direct.core.validation.defects.params;

import java.math.BigDecimal;

import ru.yandex.direct.currency.Money;

public class CurrencyAmountDefectParams {
    private final Money moneyValue;

    public CurrencyAmountDefectParams(Money moneyValue) {
        this.moneyValue = moneyValue;
    }

    public Money getMoneyValue() {
        return moneyValue;
    }

    /**
     * Костыль. Нужен т.к. у Money нет правильного (начинающегося с префикса get) геттера для занчения value и, соответственно,
     * оно не серриализуется при помощи JsonUtils.toJson(params), когда пытаемся в GraphQL вернуть дефект с параметром типа Money.
     */
    public BigDecimal getMoneyPriceValue() {
        return moneyValue.bigDecimalValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CurrencyAmountDefectParams that = (CurrencyAmountDefectParams) o;

        return moneyValue != null ? moneyValue.equals(that.moneyValue) : that.moneyValue == null;
    }

    @Override
    public int hashCode() {
        return moneyValue != null ? moneyValue.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "CurrencyAmountDefectParams{" +
                "moneyValue=" + moneyValue +
                '}';
    }
}
