package ru.yandex.direct.core.validation.defects.params;

import ru.yandex.direct.validation.result.Path;

public class FieldRequirementsDefectParams {
    private Path path1;
    private Path path2;

    public Path getPath1() {
        return path1;
    }

    public Path getPath2() {
        return path2;
    }

    public FieldRequirementsDefectParams withPath1(final Path path1) {
        this.path1 = path1;
        return this;
    }

    public FieldRequirementsDefectParams withPath2(final Path path2) {
        this.path2 = path2;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FieldRequirementsDefectParams that = (FieldRequirementsDefectParams) o;

        if (path1 != null ? !path1.equals(that.path1) : that.path1 != null) {
            return false;
        }
        return path2 != null ? path2.equals(that.path2) : that.path2 == null;
    }

    @Override
    public int hashCode() {
        int result = path1 != null ? path1.hashCode() : 0;
        result = 31 * result + (path2 != null ? path2.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "FieldRequirementsDefectParams{" +
                "path1=" + path1 +
                ", path2=" + path2 +
                '}';
    }
}
