package ru.yandex.direct.core.validation.defects.params;

import ru.yandex.direct.queryrec.model.Language;

public class GeoDefectParams {
    private Language language;
    private Long bannerId;

    public Language getLanguage() {
        return language;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public GeoDefectParams withLanguage(final Language language) {
        this.language = language;
        return this;
    }

    public GeoDefectParams withBannerId(final Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    @Override
    public String toString() {
        return "GeoDefectParams{" +
                "language=" + language +
                ", bannerId=" + bannerId +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        GeoDefectParams that = (GeoDefectParams) o;

        if (language != that.language) {
            return false;
        }
        return bannerId != null ? bannerId.equals(that.bannerId) : that.bannerId == null;
    }

    @Override
    public int hashCode() {
        int result = language != null ? language.hashCode() : 0;
        result = 31 * result + (bannerId != null ? bannerId.hashCode() : 0);
        return result;
    }
}
