package ru.yandex.direct.core.validation.defects.params;

public class NumberWithIdDefectParams {
    private Number max;
    private Number min;
    private Number id1;
    private Number id2;

    public Number getMax() {
        return max;
    }

    public NumberWithIdDefectParams withMax(Number max) {
        this.max = max;
        return this;
    }

    public Number getMin() {
        return min;
    }

    public NumberWithIdDefectParams withMin(Number min) {
        this.min = min;
        return this;
    }


    public Number getId1() {
        return id1;
    }

    public NumberWithIdDefectParams withId1(Number id1) {
        this.id1 = id1;
        return this;
    }

    public Number getId2() {
        return id2;
    }

    public NumberWithIdDefectParams withId2(Number id2) {
        this.id2 = id2;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        NumberWithIdDefectParams that = (NumberWithIdDefectParams) o;

        if (max != null ? !max.equals(that.max) : that.max != null) {
            return false;
        }
        if (min != null ? !min.equals(that.min) : that.min != null) {
            return false;
        }
        if (id1 != null ? !id1.equals(that.id1) : that.id1 != null) {
            return false;
        }
        if (id2 != null ? !id2.equals(that.id2) : that.id2 != null) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = max != null ? max.hashCode() : 0;
        result = 31 * result + (min != null ? min.hashCode() : 0);
        result = 31 * result + (id1 != null ? id1.hashCode() : 0);
        result = 31 * result + (id2 != null ? id2.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "NumberWithIdDefectParams{" +
                "max=" + max +
                ", min=" + min +
                ", id1=" + id1 +
                ", id2=" + id2 +
                '}';
    }
}
