package ru.yandex.direct.core.validation.defects.params;

import java.util.Objects;
import java.util.Set;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackageRetargetingSubCategory;

public class PriceSalesTargetingAmountDefectParams {
    private Integer currentAmount;
    private Integer lowerLimit;
    private Integer upperLimit;
    private Set<PricePackageRetargetingSubCategory> categories;

    public Integer getCurrentAmount() {
        return currentAmount;
    }

    public PriceSalesTargetingAmountDefectParams withCurrentAmount(Integer currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    public Integer getLowerLimit() {
        return lowerLimit;
    }

    public PriceSalesTargetingAmountDefectParams withLowerLimit(Integer lowerLimit) {
        this.lowerLimit = lowerLimit;
        return this;
    }

    public Integer getUpperLimit() {
        return upperLimit;
    }

    public PriceSalesTargetingAmountDefectParams withUpperLimit(Integer upperLimit) {
        this.upperLimit = upperLimit;
        return this;
    }

    public Set<PricePackageRetargetingSubCategory> getCategories() {
        return categories;
    }

    public PriceSalesTargetingAmountDefectParams withCategories(Set<PricePackageRetargetingSubCategory> categories) {
        this.categories = categories;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(currentAmount, lowerLimit, upperLimit, categories);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PriceSalesTargetingAmountDefectParams that = (PriceSalesTargetingAmountDefectParams) o;

        return (this.getCurrentAmount().equals(that.getCurrentAmount()) &&
                this.getLowerLimit().equals(that.getLowerLimit()) &&
                this.getUpperLimit().equals(that.getUpperLimit()) &&
                this.getCategories().equals(that.getCategories()));
    }

    @Override
    public String toString() {
        return "PriceSalesTargetingAmountDefectParams { " +
                "currentAmount=" + currentAmount +
                ", lowerLimit=" + lowerLimit +
                ", upperLimit=" + upperLimit +
                ", categories=" + categories +
                "}";
    }
}
