package ru.yandex.direct.core.validation.defects.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Параметры для DefectId, когда ошибка касается строковой коллекции и состоит
 * в том, что часть элементов в ней не подходит по длине: слишком длинная,
 * слишком короткая или слишком много слов.
 */
@ParametersAreNonnullByDefault
public class StringCollectionSubsetStringDefectParams {
    private final List<String> subset;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxWords;

    private StringCollectionSubsetStringDefectParams(Collection<String> subset) {
        this.subset = new ArrayList<>(subset);
    }

    public static StringCollectionSubsetStringDefectParams of(Collection<String> subset) {
        return new StringCollectionSubsetStringDefectParams(checkNotNull(subset));
    }

    public StringCollectionSubsetStringDefectParams withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public StringCollectionSubsetStringDefectParams withMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringCollectionSubsetStringDefectParams withMaxWords(int maxWords) {
        this.maxWords = maxWords;
        return this;
    }

    public List<String> getSubset() {
        return subset;
    }

    public Integer getMaxLength() {
        return maxLength;
    }

    public Integer getMinLength() {
        return minLength;
    }

    public Integer getMaxWords() {
        return maxWords;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StringCollectionSubsetStringDefectParams that = (StringCollectionSubsetStringDefectParams) o;

        return subset.equals(that.subset)
                && (maxLength != null ? maxLength.equals(that.maxLength) : that.maxLength == null)
                && (minLength != null ? minLength.equals(that.minLength) : that.minLength == null)
                && (maxWords != null ? maxWords.equals(that.maxWords) : that.maxWords == null);
    }

    @Override
    public int hashCode() {
        int result = subset.hashCode();
        result = 31 * result + (maxLength != null ? maxLength.hashCode() : 0);
        result = 31 * result + (minLength != null ? minLength.hashCode() : 0);
        result = 31 * result + (maxWords != null ? maxWords.hashCode() : 0);
        return result;
    }
}
