package ru.yandex.direct.core.validation.defects.params;

import java.util.List;
import java.util.Objects;

import ru.yandex.direct.currency.CurrencyCode;

public class UnavailableCurrencyDefectParams {
    private final CurrencyCode currency;
    private final List<CurrencyCode> availableCurrencies;

    public UnavailableCurrencyDefectParams(CurrencyCode currency, List<CurrencyCode> availableCurrencies) {
        this.currency = currency;
        this.availableCurrencies = availableCurrencies;
    }

    public CurrencyCode getCurrency() {
        return currency;
    }

    public List<CurrencyCode> getAvailableCurrencies() {
        return availableCurrencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnavailableCurrencyDefectParams that = (UnavailableCurrencyDefectParams) o;
        return currency == that.currency &&
                Objects.equals(availableCurrencies, that.availableCurrencies);
    }

    @Override
    public int hashCode() {

        return Objects.hash(currency, availableCurrencies);
    }

    @Override
    public String toString() {
        return "AvailableCurrencyDefectParams{" +
                "currency=" + currency +
                ", availableCurrencies=" + availableCurrencies +
                '}';
    }
}
