package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.model.AppInfo
import ru.yandex.direct.core.entity.uac.model.AppInfoContent

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class AppInfoWithContent(
    val appInfo: AppInfo,
    val contents: List<AppInfoContent>,
    @get:JsonProperty("is_tracking_url") val isTrackingUrl: Boolean,
    val defaultTargetRegion: Long?,
    val defaultTargetRegionName: String?,
)
